/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SFNODE
#define SFNODE

// define (remove _NOT) to have helpful debugging cout-s
#define DEBUG_PARSE_NOT
#define DEBUG_EVENTS_NOT
#define DEBUG_RENDER_NOT
#define DEBUG_PREPARE_NOT

// C++ includes
#include <stdlib.h>
#include <iostream.h>

// C includes
#include <math.h>
#include <string.h>
#include <ctype.h>

// OpenGL includes
#include <GL/gl.h>
#include <GL/glu.h>  

// classes
class Children;
class SFVec3f;
class SFRenderInfo;
class SFEvent;
class SFBool;
class SFString;

// class definition
class SFNode {

 public:

  // constructor
  SFNode(char *n) {
    strcpy(privateNodeType,    n);
    privateEventQueue     = (Children *) 0;
    privateIsValid        = false;
    privateUnsatisfiedUSE = false;
    CallNum               = 0;
  }

  // destructor
  virtual ~SFNode() {
  }

  // parse
  virtual void parse  (char         *, istream      &) {
  }

  // prepare
  virtual void prepare(SFVec3f      &, SFVec3f      &) {
  }

  // render
  virtual void render (SFRenderInfo &) {
  }

  // events
  virtual void eventIn (SFString &, SFNode *) {
  }
  virtual void eventOut(SFString &, SFNode *) {
  }

  // USE-DEF
  virtual SFNode *findUSE() {
    if (unsatisfiedUSE()) return(this);
    return ((SFNode *) 0);
  }
  virtual SFNode *findDEF(SFString &) {
    return((SFNode *) 0);
  }
  virtual SFString *use() {
    return((SFString *) 0);
  }

  // stack
  virtual void push(Children &, SFString &);

  // is the node valid
  virtual bool &isValid() {
    return(privateIsValid);
  }

  // access
  Children* &eventQueue() {
    return(privateEventQueue);
  }
  void addEvent(SFEvent *);

  // access
  char * nodeType() {
    return(privateNodeType);
  }
  void markUseFound() {
    privateUnsatisfiedUSE = false;
  }
  void copy(SFNode *);

 protected:

  // outputs a warning that token not understood
  void parseWarning(char *CurToken) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << ")::operator >>\n";
    cerr << "\tUnknown Token Read (" << CurToken << ")\n";
    exit(0);
  }

  // whether or not a use is present
  bool &unsatisfiedUSE() {
    return(privateUnsatisfiedUSE);
  }

  // holds a call list number to be used for speedy rendering
  GLuint CallNum;

 private:

  // data
  char      privateNodeType[1024];
  Children *privateEventQueue;
  bool      privateIsValid;
  bool      privateUnsatisfiedUSE;

};

#endif // SFNode

