/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef SFEVENT
#define SFEVENT

// label
#define SFEventLabel "SFEvent"

// classes
#include <SFNode.h>
#include <SFString.h>

// class definition
class SFEvent : public SFNode {

 public:

  // constructor
  SFEvent() : SFNode(SFEventLabel) {
    privateFrom = (SFNode *) 0;
    privateTo   = (SFNode *) 0;
  }
    
  // destructor
  ~SFEvent() {
  }

  // parse
  void parse(char *, istream &);

  // operators 
  SFEvent &operator = (SFEvent &E2) {
    eventFromName() = E2.eventFromName();
    eventToName()   = E2.eventToName();
    nodeFromName()  = E2.nodeFromName();
    nodeToName()    = E2.nodeToName();
    from()          = E2.from();
    to()            = E2.to();
    return(*this);
  }

  // access
  SFNode*   &from() {
    return(privateFrom);
  }
  SFNode*   &to() {
    return(privateTo);
  }
  SFString  &eventFromName() {
    return(privateEventFromName);
  }
  SFString  &eventToName() {
    return(privateEventToName);
  }
  SFString  &nodeFromName() {
    return(privateNodeFromName);
  }
  SFString  &nodeToName() {
    return(privateNodeToName);
  }

 protected:

 private:

  // data
  SFString   privateEventFromName;
  SFString   privateEventToName;
  SFString   privateNodeFromName;
  SFString   privateNodeToName;
  SFNode    *privateFrom;
  SFNode    *privateTo;
  
};

#endif // SFEvent


