/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef PIXELTEXTURE
#define PIXELTEXTURE

// label
#define PixelTextureLabel    "PixelTexture"

// classes
#include <SFNode.h>
#include <SFImage.h>
#include <SFBool.h>
#include <SFString.h>

// class definition
class PixelTexture : public SFNode {

 public:

  // constructor
  PixelTexture() : SFNode(PixelTextureLabel) {
    repeatS = true;
    repeatT = true;
  }
  
  // destructor
  ~PixelTexture() {
  }

  // parse
  void parse  (char         *, istream      &);

  // render
  void render (SFRenderInfo &);

  // events
  void eventIn (SFString    &, SFNode       *);

  // operators
  PixelTexture &operator = (PixelTexture &P2) {
    if (image.isValid()) image = P2.image;
    repeatS              = P2.repeatS;
    repeatT              = P2.repeatT;
    isValid()            = P2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFImage  image;
  SFBool   repeatS;
  SFBool   repeatT;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // PixelTexture




