/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef NAVIGATIONINFO
#define NAVIGATIONINFO

// the label
#define NavigationInfoLabel       "NavigationInfo"

// the super class
#include <SFNode.h>

// local classes
#include <SFBool.h>
#include <SFFloat.h>
#include <MFFloat.h>
#include <MFString.h>

// class definition
class NavigationInfo : public SFNode {

public:

  // constructor
  NavigationInfo() : SFNode(NavigationInfoLabel) {
    headlight       = true;
    speed           = 1.0;
    visibilityLimit = 0.0;
    isBound         = false;
  }

  // destructor
  ~NavigationInfo() {
  }

  // parse
  void parse   (char     *, istream &);
    
  // events
  void eventIn (SFString &, SFNode  *);
  void eventOut(SFString &, SFNode  *);

  // operators
  NavigationInfo &operator = (NavigationInfo &N2) {
    avatarSize             = N2.avatarSize;
    headlight              = N2.headlight;
    speed                  = N2.speed;
    type                   = N2.type;
    visibilityLimit        = N2.visibilityLimit;
    isBound                = N2.isBound;
    isValid()              = N2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

protected:
  
private:

  // data
  MFFloat  avatarSize;
  SFBool   headlight;
  SFFloat  speed;
  MFString type;
  SFFloat  visibilityLimit;

  // event data
  SFBool   isBound;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // NavigationInfo



