/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef MOVIETEXTURE
#define MOVIETEXTURE

// label
#define MovieTextureLabel    "MovieTexture"

// classes
#include <SFNode.h>
#include <SFImage.h>
#include <SFBool.h>
#include <SFTime.h>
#include <SFUrl.h>
#include <SFFloat.h>

// class definition
class MovieTexture : public SFNode {

 public:

  // constructor
  MovieTexture() : SFNode(MovieTextureLabel) {
    speed     = 1.0;
    loop      = false;
    startTime = 0.0;
    stopTime  = 0.0;  
    repeatS   = true;
    repeatT   = true;
  }
  
  // destructor
  ~MovieTexture() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode *);
  void eventOut(SFString     &, SFNode *);

  // operators
  MovieTexture &operator = (MovieTexture &M2) {
    if (image.isValid()) image = M2.image;
    url                  = M2.url;
    speed                = M2.speed;
    startTime            = M2.startTime;
    stopTime             = M2.stopTime;
    repeatS              = M2.repeatS;
    repeatT              = M2.repeatT;
    isValid()            = M2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFUrl    url;
  SFFloat  speed;
  SFBool   loop;
  SFTime   startTime;
  SFTime   stopTime;  
  SFImage  image;
  SFBool   repeatS;
  SFBool   repeatT;

  // event data
  SFFloat  duration_changed;
  SFBool   isActive;

  // USE-DEF
  SFString  DEF;
  SFString  USE;

};

#endif // MovieTexture




