/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef MFROTATION
#define MFROTATION

// label
#define MFRotationLabel           "MFRotation"

// classes
#include <SFNode.h>
#include <SFRotation.h>

// class definition
class MFRotation : public SFNode {

 public:

  // constructor
  MFRotation() : SFNode(MFRotationLabel) {
    numElements = 0;
    data        = (SFRotation *) 0;
  }
  
  // destructor
  ~MFRotation() {
    if (data   != (SFRotation *) 0) delete[] data;    
    data        = (SFRotation *) 0;
    numElements = 0;
  }

  // parse
  void parse(char *, istream &);

  // operators
  MFRotation &operator = (MFRotation &M2) {
    alloc(M2.numElements);
    for (int i = 0; i < M2.numElements; i++) data[i] = M2.data[i];
    isValid()       = M2.isValid();
    return(*this);
  }

  // access 
  int num() {
    return(numElements);
  }
  SFRotation  & operator [] (int i) {
    if ((i < 0) || (i >= numElements)) {
      cerr << "\nError:\n";
      cerr << "\tOccurred in MFRotation::operator()\n";
      cerr << "\tOut of array bounds access (" << i << ")";
      cerr << " of (" << numElements << ")\n";
      exit(0);
    }
    return(data[i]);
  }

  // allocate
  void alloc (int n) {
    numElements = n;
    data        = new SFRotation[n];
    if (data   == (SFRotation *) 0) {  
      cerr << "\nError:\n";
      cerr << "\tOccurred in MFRotation::alloc(" << n << ")\n";
      cerr << "\tCould not allocate requested memory\n";
      exit(0);
    }
  }

 protected:

 private:

  //  data
  int         numElements;
  SFRotation *data;

};

#endif // MFRotation
