/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef MFINT32
#define MFINT32

// label
#define MFInt32Label "MFInt32"

// classes
#include <SFNode.h>
#include <SFInt32.h>

// class definition
class MFInt32 : public SFNode {

 public:

  // constructor
  MFInt32() : SFNode(MFInt32Label) {
    numElements = 0;
    data        = (SFInt32 *) 0;
  }
  
  // destructor
  ~MFInt32() {
    if (data   != (SFInt32 *) 0) delete[] data;    
    numElements = 0;
    data        = (SFInt32 *) 0;
  }
  
  // parse
  void parse(char *, istream &);
  
  // operators
  MFInt32 &operator = (MFInt32 &M2) {
    alloc(M2.numElements);
    for (int i = 0; i < M2.numElements; i++) data[i] = M2.data[i];
    isValid()       = M2.isValid();
    return(*this);
  }
  SFInt32  & operator [] (int i) {
    if ((i < 0) || (i >= numElements)) {
      cerr << "\nError:\n";
      cerr << "\tOccurred in MFInt32::operator()\n";
      cerr << "\tOut of array bounds access (" << i;
      cerr << ") of (" << numElements << ")\n";
      exit(0);
    }
    return(data[i]);
  }

  // allocate
  void alloc(int n) {
    isValid() = true;
    numElements = n;
    data = new SFInt32[n];
    if (data == (SFInt32 *) 0) { 
      cerr << "\nError:\n";
      cerr << "\tOccurred in MFInt32::alloc(" << n << ")\n";
      cerr << "\tCould not allocate memory\n";
      exit(0);
    }
  }

  // access
  int num() {
    return(numElements);
  }
      
 protected:

 private:

  // data
  int      numElements;
  SFInt32 *data;

};

#endif // MFInt32
