/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef LOD
#define LOD

// label
#define LodLabel "Lod"

// classes
#include <SFNode.h>
#include <Children.h>
#include <MFFloat.h>
#include <SFVec3f.h>
#include <SFString.h>

// class definition
class Lod : public SFNode {

 public:

  // constructor
  Lod() : SFNode(LodLabel) {
    center[0] = 0.0;
    center[1] = 0.0;
    center[2] = 0.0;
  }
    
  // destructor
  ~Lod() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);
 
  // events
  void eventIn (SFString      &, SFNode *);

  // operators
  Lod &operator = (Lod &L2) {
    range       = L2.range;
    center      = L2.center;
    level       = L2.level;
    isValid()   = L2.isValid();
    return(*this);
  }
  
  // Queue
  void push(Children &stack, SFString &stackType) {
    if (stackType == nodeType()) stack.add(this);
    else                         level.push(stack, stackType);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return(level.findDEF(UnsatUSE));
  }
  SFNode *findUSE() {
    if (unsatisfiedUSE()) return(this);
    return(level.findUSE());
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  MFFloat  range;
  SFVec3f  center;
  Children level;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // LOD
