/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef INDEXEDFACESET
#define INDEXEDFACESET

// label
#define IndexedFaceSetLabel "IndexedFaceSet"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFFloat.h>
#include <Color.h>
#include <Normal.h>
#include <TextureCoordinate.h>
#include <Coordinate.h>
#include <MFInt32.h>

// class definition
class IndexedFaceSet : public SFNode {

public:

  // constructor
  IndexedFaceSet() : SFNode(IndexedFaceSetLabel) {
    creaseAngle     = 0.0;
    ccw             = true;
    solid           = true;
    convex          = true;
    colorPerVertex  = true;
    normalPerVertex = true;
  }

  // destructor
  ~IndexedFaceSet() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);
    
  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode       *);

  // operators
  IndexedFaceSet &operator = (IndexedFaceSet &I2) {
    color                  = I2.color;
    colorIndex             = I2.colorIndex;
    coord                  = I2.coord;
    coordIndex             = I2.coordIndex;
    texCoord               = I2.texCoord;
    texCoordIndex          = I2.texCoordIndex;
    colorPerVertex         = I2.colorPerVertex;
    normal                 = I2.normal;
    normalIndex            = I2.normalIndex;
    normalPerVertex        = I2.normalPerVertex;
    creaseAngle            = I2.creaseAngle;
    ccw                    = I2.ccw;
    solid                  = I2.solid;
    convex                 = I2.convex;
    isValid()              = I2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findUSE() {
    SFNode *MFN = (SFNode *) 0;
    if (unsatisfiedUSE()) {
      MFN = (SFNode *) this;
    } else {
      MFN = coord.findUSE();
      if (MFN == (SFNode *) 0) {
	MFN = texCoord.findUSE();
	if (MFN == (SFNode *) 0) {
	  MFN = coordIndex.findUSE();
	  if (MFN == (SFNode *) 0) {
	    MFN = color.findUSE();
	    if (MFN == (SFNode *) 0) {
	      MFN = normal.findUSE();
	    }
	  }
	}
      }
    }
    return(MFN);
  }
  SFNode *findDEF(SFString &UnsatUSE) {
    SFNode *MFN = (SFNode *) 0;
    if (UnsatUSE == DEF) {
      MFN = (SFNode *) this;
    } else {
      MFN = coord.findDEF(UnsatUSE);
      if (MFN == (SFNode *) 0) {
	MFN = texCoord.findDEF(UnsatUSE);
	if (MFN == (SFNode *) 0) {
	  MFN = coordIndex.findDEF(UnsatUSE);
	  if (MFN == (SFNode *) 0) {
	    MFN = color.findDEF(UnsatUSE);
	    if (MFN == (SFNode *) 0) {
	      MFN = normal.findDEF(UnsatUSE);
	    }
	  }
	}
      }
    }
    return(MFN);
  }
  SFString *use() {
    return(&USE);
  }

protected:

private:

  // data
  Coordinate        coord;
  MFInt32           coordIndex;
  Color             color;
  MFInt32           colorIndex;
  Normal            normal;
  MFInt32           normalIndex;
  TextureCoordinate texCoord;
  MFInt32           texCoordIndex;
  SFFloat           creaseAngle;
  SFBool            ccw;
  SFBool            solid;
  SFBool            convex;
  SFBool            normalPerVertex;
  SFBool            colorPerVertex;

  // USE-DEF
  SFString          DEF;
  SFString          USE;

};

#endif // IndexedFaceSet
