/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef IMAGETEXTURE
#define IMAGETEXTURE

// label
#define ImageTextureLabel "ImageTexture"

// classes
#include <SFNode.h>
#include <SFImage.h>
#include <SFBool.h>
#include <SFUrl.h>

// class definition
class ImageTexture : public SFNode {

 public:

  // constructor
  ImageTexture() : SFNode(ImageTextureLabel) {
    repeatS = true;
    repeatT = true;
  }
  
  // destructor
  ~ImageTexture() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode *);

  // operators
  ImageTexture &operator = (ImageTexture &I2) {
    if (I2.image.isValid()) image = I2.image;
    repeatS              = I2.repeatS;
    repeatT              = I2.repeatT;
    if (I2.url.isValid()) url = I2.url;
    isValid()            = I2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFUrl   url;
  SFImage image;
  SFBool  repeatS;
  SFBool  repeatT;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // ImageTexture


