/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef BACKGROUND
#define BACKGROUND

// label
#define BackgroundLabel "Background"

// classes
#include <SFNode.h>
#include <SFUrl.h>
#include <SFBool.h>
#include <SFInt32.h>
#include <SFImage.h>
#include <MFFloat.h>
#include <MFColor.h>

// class definition
class Background : public SFNode {

public:

  // constructor
  Background():SFNode(BackgroundLabel) {
    isBound = false;
  }

  // destructor
  ~Background() {
  }

  // parse
  void parse    (char        *, istream      &);

  // prepare
  void prepare  (SFVec3f     &, SFVec3f      &);
    
  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode       *);
  void eventOut(SFString     &, SFNode       *);

  // operators
  Background &operator = (Background &B2) {
    groundColor        = B2.groundColor;
    groundAngle        = B2.groundAngle;
    skyColor           = B2.skyColor;
    skyAngle           = B2.skyAngle;
    frontUrl           = B2.frontUrl;
    backUrl            = B2.backUrl;
    rightUrl           = B2.rightUrl;
    leftUrl            = B2.leftUrl;
    topUrl             = B2.topUrl;
    bottomUrl          = B2.bottomUrl;
    leftImage          = B2.leftImage;
    rightImage         = B2.rightImage;
    frontImage         = B2.frontImage;
    topImage           = B2.topImage;
    botImage           = B2.botImage;
    isBound            = B2.isBound;
    isValid()          = B2.isValid;
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
    SFString *use() {
    return(&USE);
  }

protected:

  // create the image 
  void ComputeInterpolatedImage(SFImage &, SFUrl &url);
  void ComputeSolidImage(SFImage &, SFUrl &url, SFColor &);

  // do color interpolation between sky and ground
  void InterpolateSkyToGround(SFImage &);
  void InterpolateGroundToSky(SFImage &);

  // create texture maps
  void Interpolate(SFImage &);
  void Solid(SFImage &, SFColor &);

private:

  // data
  MFColor   groundColor;
  MFFloat   groundAngle;
  MFColor   skyColor;
  MFFloat   skyAngle;
  SFUrl     frontUrl;
  SFUrl     backUrl;
  SFUrl     rightUrl;
  SFUrl     leftUrl;
  SFUrl     topUrl;
  SFUrl     bottomUrl;
  SFImage   backImage;
  SFImage   leftImage;
  SFImage   rightImage;
  SFImage   frontImage;
  SFImage   topImage;
  SFImage   botImage;

  // event data
  SFBool    isBound;

  // USE-DEF
  SFString    DEF;
  SFString    USE;

};

#endif // Background


