/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef AUDIOCLIP
#define AUDIOCLIP

// label
#define AudioClipLabel "AudioClip"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFUrl.h>
#include <SFFloat.h>
#include <SFTime.h>

// class definition
class AudioClip : public SFNode {

 public:

  // constructor
  AudioClip() : SFNode(AudioClipLabel) {
    loop            = false;
    pitch           = 1.0;
    startTime       = 0.0;
    stopTime        = 0.0;
    isActive        = false;
    durationChanged = -1.0;
  }
  
  // destructor
  ~AudioClip() {
  }

  // parse
  void parse   (char         *, istream     &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode     *);
  void eventOut(SFString     &, SFNode     *);

  // operators
  AudioClip &operator = (AudioClip &A2) {
    description     = A2.description;
    loop            = A2.loop;
    pitch           = A2.pitch;
    startTime       = A2.startTime;
    url             = A2.url;
    durationChanged = A2.durationChanged;
    isActive        = A2.isActive;
    isValid()       = A2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFString description;
  SFBool   loop;
  SFFloat  pitch;
  SFTime   startTime;
  SFTime   stopTime;
  SFUrl    url;

  // event data
  SFTime   durationChanged;
  SFBool   isActive;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // AudioClip
