#include "surfaces.h"
#include "engine.h"
#include <math.h>

// Initialization of static members
LatTyp Surface::Lattice;
ColorTable Surface::MarbleTab;
ColorTable Surface::HellTab;
bool Surface::hellTableGenerated = false;
bool Surface::marbleTableGenerated = false;

Surface::Surface()
{
  Od = Color ( 0.5, 0.5, 0.5 );
  Oe = 10.0;
  N = 1.0;
  Refl = false;
  Trans = false;
  SpecC = Color( 0.5, 0.5, 0.5 );
  TransC = Color( 1.0, 1.0, 1.0 );
};

SkySurface::SkySurface()
{
  Od = Color ( 0.5, 0.5, 0.5 );
  Oe = 1.0;
  N = 1.0;
  Refl = false;
  Trans = false;
  SpecC = Color( 0.5, 0.5, 0.5 );
  TransC = Color( 1.0, 1.0, 1.0 );
};

HellSurface::HellSurface()
{
  Od = Color ( 0.5, 0.5, 0.5 );
  Oe = 1.0;
  N = 1.0;
  Refl = false;
  Trans = false;
  SpecC = Color( 0.5, 0.5, 0.5 );
  TransC = Color( 1.0, 1.0, 1.0 );
  generateHellTable();
};

Water::Water()
{
  Od = Color ( 0.3, 0.3, 0.3 );
  Oe = 8.0;
  N = 1.33;
  Refl = true;
  Trans = true;
  SpecC = Color( 0.6, 0.6, 0.6 );
  TransC = Color( 0.3, 0.3, 0.3 );
};

Marble::Marble()
{
  Od = Color ( 1.0, 1.0, 1.0 );
  Oe = 8.0;
  N = 1.0;
  Refl = true;
  Trans = false;
  SpecC = Color( 0.3, 0.3, 0.3 );
  TransC = Color( 1.0, 1.0, 1.0 );
  generateMarbleTable();
};

Glass::Glass()
{
  Od = Color ( 0.1, 0.1, 0.1 );
  Oe = 20.0;
  N = 1.5;
  Refl = true;
  Trans = true;
  SpecC = Color( 0.5, 0.5, 0.5 );
  TransC = Color( 0.5, 0.5, 0.5 );
};

Mirror::Mirror()
{
  Od = Color ( 0.1, 0.1, 0.1 );
  Oe = 30.0;
  N = 1.0;
  Refl = true;
  Trans = false;
  SpecC = Color( 0.9, 0.9, 0.9 );
  TransC = Color( 1.0, 1.0, 1.0 );
};

Brass::Brass()
{
  Od = Color ( 0.3, 0.3, 0.1 );
  Oe = 5.0;
  N = 1.0;
  Refl = true;
  Trans = false;
  SpecC = Color( 0.9, 0.9, 0.3 );
  TransC = Color( 1.0, 1.0, 1.0 );
};

RedSurface::RedSurface()
{
  Od = Color ( 1.0, 0.0, 0.0 );
  Oe = 12.0;
  N = 1.0;
  Refl = false;
  Trans = false;
  SpecC = Color( 0.5, 0.5, 0.5 );
  TransC = Color( 1.0, 1.0, 1.0 );
};

GreenSurface::GreenSurface()
{
  Od = Color ( 0.0, 1.0, 0.0 );
  Oe = 12.0;
  N = 1.0;
  Refl = false;
  Trans = false;
  SpecC = Color( 0.5, 0.5, 0.5 );
  TransC = Color( 1.0, 1.0, 1.0 );
};

/* getColor Functions */

Color Surface::getColor(Vector)
{
  return Od;
}

/*
void SimpleT::ColProc(long obNr, Vector, Color& c)
{
  c = ObArr[obNr]->Od;
}
*/

Color SkySurface::getColor(Vector p)
{
  double t;

  p *= 0.08;
  p.x *= 0.3;
  t = p.turbulence(Lattice);
  return Color(t,t,1.0);
}

/*
void SkyT::ColProc(long, Vector p, Color& c)
{
  double t;

  p *= 0.08;
  p.x *= 0.3;
  t = p.turbulence(Lattice);
  c.r = t;
  c.g = t;
  c.b = 1.0;
}
*/

Color Marble::getColor(Vector p)
{
  double t;
  unsigned short ci;

  p *= 0.08;
  t = p.turbulence(Lattice);
  if (t > 1)
    ci = 255;
  else
    ci = (long)floor(t * 255 + 0.5);
  return (MarbleTab[ci]);
}

/*
void MarbleT::ColProc(long, Vector p, Color& c)
{
  double t;
  uchar ci;

  p *= 0.08;
  t = p.turbulence(Lattice);
  if (t > 1)
    ci = 255;
  else
    ci = (long)floor(t * 255 + 0.5);
  c = MarbleTab[ci];
}
*/

Color HellSurface::getColor(Vector p)
{
  double t;
  unsigned short ci;

  p*=0.08;
  p.y *= 0.6;
  t = p.turbulence(Lattice);
  if (t > 1)
    ci = 255;
  else
    ci = (long)floor(t * 255 + 0.5);
  return (HellTab[ci]);
}

/*
void HellT::ColProc(long, Vector p, Color& c)
{
  double t;
  uchar ci;

  p*=0.08;
  p.y *= 0.6;
  t = p.turbulence(Lattice);
  if (t > 1)
    ci = 255;
  else
    ci = (long)floor(t * 255 + 0.5);
  c = HellTab[ci];
}
*/

Vector Surface::getNorm(Vector, Vector n )
{
  return n;
}

Vector Water::getNorm(Vector p, Vector n)
{
  Vector n1;
  double r;

  p*=0.3;
  r = sin(p.norm() * 2 * M_PI) * 0.2;
  n1 = p.dNoise(Lattice);
  n1*=r;
  n1+=n;
  n1.normalize();
  return n1;
}

/*
void WaterT::NrmProc(Vector p, Vector& n)
{
  Vector n1;
  double r;

  p*=0.3;
  r = sin(p.norm() * 2 * M_PI) * 0.2;
  n1 = p.dNoise(Lattice);
  n1*=r;
  n+=n1;
  n.normalize();
}
*/

void Surface::generateHellTable()
{
  ColTabSampleT HellCols[4] = {
    { 0,   Color( 0.8, 0.2, 0.1 ) },
    { 60,  Color( 0.8, 0.9, 0.2 ) },
    { 120, Color( 1.0, 0.9, 1.0 ) },
    { 255, Color( 0.7, 0.2, 0.0 ) }};

  if (! hellTableGenerated ) {
    generateColorTable(4L, HellCols, HellTab);
    hellTableGenerated = true;
  }
}
  
void Surface::generateMarbleTable()
{
  ColTabSampleT MarbleCols[4] = {
    { 0,   Color( 0.2, 0.1, 0.1 ) },
    { 70,  Color( 0.1, 0.8, 0.2 ) },
    { 140, Color( 1.0, 0.9, 1.0 ) },
    { 255, Color( 0.4, 0.9, 0.1 ) }};
  if (! marbleTableGenerated ) {
    generateColorTable(4L, MarbleCols, MarbleTab);
    marbleTableGenerated = true;
  } 
}

void Surface::generateColorTable(long SampleCnt, ColTabSampleT* Samples, 
				 Color *ColTab)
{
  double dr, dg, db;
  long i, j, d;
  Color c, c1;
  long FORLIM1;

  memset(ColTab, 0, sizeof(ColorTable));
  for (i = 0; i <= SampleCnt - 2; i++) {
    d = ((ColTabSampleT *)Samples)[i + 1].Nr - ((ColTabSampleT *)Samples)[i].Nr - 1;
    if (d > 0) {
      c = ((ColTabSampleT *)Samples)[i].c;
      c1 = ((ColTabSampleT *)Samples)[i + 1].c;
      dr = (c1.r - c.r) / d;
      dg = (c1.g - c.g) / d;
      db = (c1.b - c.b) / d;
      FORLIM1 = ((ColTabSampleT *)Samples)[i + 1].Nr;
      for (j = ((ColTabSampleT *)Samples)[i].Nr; j <= FORLIM1; j++) {
	ColTab[j] = c;
	c.r += dr;
	if (c.r < 0)
	  c.r = 0.0;
	else if (c.r > 1)
	  c.r = 1.0;
	c.g += dg;
	if (c.g < 0)
	  c.g = 0.0;
	else if (c.g > 1)
	  c.g = 1.0;
	c.b += db;
	if (c.b < 0)
	  c.b = 0.0;
	else if (c.b > 1)
	  c.b = 1.0;
      }
    }
  }
}

