// -*- C++ -*-
//--------------------------------------------------------------------
// KRay Version 0.1
//
// File: engine.h
//
// Classes: Engine, Color, RayT, kugelT, zylT
//
// Purpose: This is the real Ray-tracing engine.  The code in 
// engine.cpp/.h is still like a lot of the original p2c translation.
// I will spend some time here later to make this really object-
// oriented and to clean up.
//
// DON'T LOOK TO CLOSELY AT THE CODE IN ENGINE.CPP/ENGINE.H#
//--------------------------------------------------------------------
#ifndef __engine_h
#define __engine_h

#include <qobject.h>
#include "vector.h"

#define anzKugel        2   /*war 26*/
#define PicSizeWC       12
#define PixRat          1.0
#define Infinity        1e20
#define Epsilon         1e-10
#define maxRekDep       20
#define AttenEps        0.01

class Screen;

class Color {
public:
  Color();
  Color(double, double, double);
  double r, g, b;
};

class rayT {
public:
  rayT();
  rayT(Vector, Vector);
  Vector p, n;
};

class kugelT {
public:
  kugelT(Vector, double);
  Vector m;
  double sqrr;
};

class zylT {
public:
  zylT(Vector, Vector, double);
  Vector bot, top;
  double sqrr;
};


typedef kugelT kugarrT[anzKugel];
typedef Color ColorTable[256];
typedef struct ColTabSampleT
{
  uchar Nr;
  Color c;
} ColTabSampleT;
typedef ColTabSampleT SampT[101];

class Engine : public QObject
{
    Q_OBJECT
public:
    Engine(int, int, int, int, int, int, int);
    static void errEps(double s);
public slots:
    void calculate();
signals:
    void emitPixel(int, int, int, int, int);
protected:
    Vector RayToPoint(rayT r, double l);
    Vector ReflV(Vector ve, Vector n);
    bool TransV(Vector ve, Vector n, double n1, double n2, Vector& vt);
    double pow(double x, double y);
    void sqrSolve(double p, double q, double *lam);
    void intersect(rayT *r, long *obNr, double *lMin);
    bool InShadow(Vector p);
    bool GetNrm(long ObNr, Vector p, Vector ve, Vector& n);
    Color Light(long ObNr, Vector p, Vector n, Vector, Vector vr);
    Color trace(rayT r, long RekDep, double N1, double atten);
    void generateColorTable(long SampleCnt, ColTabSampleT* Samples, 
			    Color *ColTab);
    void SetProp(uchar ObNr, int Nr);
    void paintPixel(int, int, int, int, int);
private:
    int xmax, ymax;
};

#endif
