#include <kapp.h>
#include "kblinselconfig.h"

KBlinselConfig::KBlinselConfig(KConfig *config)
{
 tabctl = new KTabCtl(this);
 tempconf = config;
 tabctl->setGeometry(0,0,400,170);

 patternPage = new QWidget(tabctl);
 advancePage = new QWidget(tabctl);
 printPage = new QWidget(tabctl);

 tempconf->setGroup("Pattern");
 setMinimumSize(400,200);
 setMaximumSize(400,200);

 QLabel *patternDir_lb = new QLabel(i18n("Pattern Directory"),patternPage);
 patternDir_lb->setGeometry(10,20,110,20);

 patternDir_ed = new KLined(patternPage);
 patternDir_ed->setGeometry(120,20,220,20);
 patternDir_ed->setText(tempconf->readEntry("PatternDir",KApplication::kde_datadir()+"/kblinsel/patterns/"));

 QLabel *patternSfx_lb = new QLabel(i18n("Pattern Suffix"),patternPage);
 patternSfx_lb->setGeometry(10,42,110,20);

 patternSfx_ed = new KLined(patternPage);
 patternSfx_ed->setGeometry(120,42,50,20);
 patternSfx_ed->setText(tempconf->readEntry("PatternSuffix","*.xpm"));

 QPushButton *browse = new QPushButton(i18n("..."),patternPage);
 browse->setGeometry(340,20,50,20);

 patternCopy = new QCheckBox(i18n("Save dropped patterns in pattern directory"),patternPage);
 patternCopy->setGeometry(10,86,300,20);
 patternCopy->setChecked(tempconf->readBoolEntry("saveDropPattern", false));


 tempconf->setGroup("Algorithm");
 QLabel *advanceNULL_lb = new QLabel(i18n("max. distance (0..3)"),advancePage);
 advanceNULL_lb->setGeometry(10,20,150,20);
 advanceDist_ed = new KLined(advancePage);
 advanceDist_ed->setGeometry(150,20,50,20);
 advanceDist_ed->setText(tempconf->readEntry("maxDistance","1.50"));

 QLabel *printNULL_lb = new QLabel("not yet done!",printPage);
 printNULL_lb->setGeometry(100,50,100,20);

 tabctl->addTab(patternPage,i18n("Pattern"));
 tabctl->addTab(advancePage,i18n("Algorithm"));
 tabctl->addTab(printPage,i18n("Print"));
 tabctl->show();

 confOK = new QPushButton(i18n("OK"),this);
 confOK->setGeometry(250,170,75,25);

 confCancel = new QPushButton(i18n("Cancel"),this);
 confCancel->setGeometry(325,170,75,25);


 connect(browse,SIGNAL(clicked()),SLOT(browse_pressed()));
 connect(confCancel,SIGNAL(clicked()),SLOT(cancel_pressed()));
 connect(confOK,SIGNAL(clicked()),SLOT(ok_pressed()));

 show();
}

KBlinselConfig::~KBlinselConfig()
{
}



void KBlinselConfig::ok_pressed()
{
 QString *tmpStr;
 tmpStr = new QString();
 tempconf->setGroup("Pattern");
 tempconf->writeEntry("PatternDir",(const char *)patternDir_ed->text());
 tempconf->writeEntry("PatternSuffix",(const char *)patternSfx_ed->text());
 tempconf->writeEntry("saveDropPattern",patternCopy->isChecked());
 tempconf->setGroup("Algorithm");
 *tmpStr =  advanceDist_ed->text();
 tempconf->writeEntry("maxDistance",tmpStr->toDouble() );
 tempconf->sync();
 emit isready(true);
 hide();
 delete(tmpStr);
}

void KBlinselConfig::cancel_pressed()
{
 hide();
}

void KBlinselConfig::browse_pressed()
{
 QString s;
 s = KFileDialog::getDirectory("./");
 if(s.isEmpty()) return;
 patternDir_ed->setText((const char *)s);
}
