#include <kapp.h>
#include "kblinselconfig.h"

KBlinselConfig::KBlinselConfig(KConfig *config)
{
 tempconf = config;
 tempconf->setGroup("Pattern");
 setMinimumSize(400,200);
 setMaximumSize(400,200);

 QLabel *patternDir_lb = new QLabel(i18n("Pattern Directory"),this);
 patternDir_lb->setGeometry(10,20,110,20);

 patternDir_ed = new KLined(this);
 patternDir_ed->setGeometry(120,20,220,20);
 patternDir_ed->setText(tempconf->readEntry("PatternDir",KApplication::kde_datadir()+"/kblinsel/patterns/"));

 QLabel *patternSfx_lb = new QLabel(i18n("Pattern Suffix"),this);
 patternSfx_lb->setGeometry(10,42,110,20);

 patternSfx_ed = new KLined(this);
 patternSfx_ed->setGeometry(120,42,50,20);
 patternSfx_ed->setText(tempconf->readEntry("PatternSuffix","*.xpm"));

 confOK = new QPushButton(i18n("OK"),this);
 confOK->setGeometry(250,170,75,25);

 confCancel = new QPushButton(i18n("Cancel"),this);
 confCancel->setGeometry(325,170,75,25);

 QPushButton *browse = new QPushButton(i18n("..."),this);
 browse->setGeometry(340,20,50,20);

 connect(browse,SIGNAL(clicked()),SLOT(browse_pressed()));
 connect(confCancel,SIGNAL(clicked()),SLOT(cancel_pressed()));
 connect(confOK,SIGNAL(clicked()),SLOT(ok_pressed()));

 show();
}

KBlinselConfig::~KBlinselConfig()
{
}



void KBlinselConfig::ok_pressed()
{
 tempconf->setGroup("Pattern");
 tempconf->writeEntry("PatternDir",(const char *)patternDir_ed->text());
 tempconf->writeEntry("PatternSuffix",(const char *)patternSfx_ed->text());
 tempconf->sync();
 emit isready(true);
 delete(this);
}

void KBlinselConfig::cancel_pressed()
{
 delete(this);
}

void KBlinselConfig::browse_pressed()
{
 QString s;
 s = KFileDialog::getDirectory("./");
 if(s.isEmpty()) return;
 patternDir_ed->setText((const char *)s);
}