#!/bin/sh

Dir=$1
VF=$2

function usage()
{
	echo
	echo
	echo "Usage: version.sh"
	echo "version.sh Dir VF"
	echo
	echo "Dir:     the directory with your sources"
	echo "VF:      the versionfile"
	echo
	echo "(c) 1999,2000 Tobias Wollgam"
	echo
	echo
}

if test -z "$Dir" -o -z "$VF"
then
	usage
	exit
fi

if test ! -d "$Dir"
then
	usage
	exit
fi

if test ! -f "$VF"
then
	usage
	exit
fi

function cutname()
{
	c=20

	Name=`echo $1 | cut -d/ -f$c`
	tmp=$Name
	while test $c -gt 1 -a -z "$tmp"
	do
		c=`expr $c - 1`
		tmp=`echo $1 | cut -d/ -f$c`
	done

	echo "$tmp"
}

function cutname2()
{
	echo `echo $1 | tr "/" "\n" | tail -n 1`
}

function cutdir()
{
	echo `echo $1 | cut -f 2- -d '/'`
}

function cutpath()
{
	if test -z `echo $1 | grep /`
	then
		echo ""
	else
		echo `echo $1 | rev | cut -f 2- -d '/' | rev`
	fi
}

function printlog()
{
	if test "$1" = "-"
	then
		echo "$2"
	else
		echo "$2" >> $1
	fi
}

function createfilelist()
{
	echo `find $1 -name *.cpp -o -name *.h -o -name *.c`
}

nlines=1

for i in `createfilelist $Dir`
do
	name=`cutname2 $i`

	c=1

	echo "$nlines. $i"

	nlines=`expr $nlines + 1`

	tmp=`cat $i | head -n $c | tail -n 1 | cut -b 1-2`
	while test "//" = "$tmp" -o "/*" = "$tmp" -o "**" = "$tmp" -o "*/" = "$tmp"
	do
		c=`expr $c + 1`
		tmp=`cat $i | head -n $c | tail -n 1 | cut -b 1-2`
	done

	nl=`cat $i | wc -l`
	n=`expr $nl - $c + 1`

	cp $VF tmp.txt
	echo "/*" >> tmp.txt
	echo "** $name" >> tmp.txt
	echo "*/" >> tmp.txt
	cat $i | tail -n $n | tr -d "\015" >> tmp.txt
	mv tmp.txt $i
done


