/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** aurender.cpp
*/

#include "../include/matmath.h"
#include "../include/misc.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#ifndef sqr
#define sqr(a)	((a) * (a))
#endif

void	errorfile()
{
	fprintf(stderr,"Broken file aurender.txt!\n");
	exit(-2);
}

void	main(int argc,char **argv)
{
	FILE		*fp,*fp2,*chfp[256];
	char		buffer[1024],command[1024];
	char		soundfile[128];
	Vector3		direction;
	int		channel,file;
	int		startms;
	int		offsetms;
	int		timems;
	int		samples;
	char		*filter,*cp;
	float		f[3];
	double		scale,vol,ang;
	int		chlen[256],i,t,maxlen;
	char		*aubuffer[3];
	Vector3		chldir[256],v1,v2;
	bool		create_stereo = false;
	
	t = 1;
	
	if(argc > 1)
	{
		if(strncmp(argv[1],"-s",2) == 0)
		{
			create_stereo = true;
			t++;
		}
	}
	
	for(i = 0;i < 256;i++)
	{
		chlen[i] = 0;
		chfp[i] = 0;
		chldir[i] = Vector3(0,0,0);
	}
	for(i = t;i < argc;i++)
	{
		float	x,y,z;
		
		sscanf(argv[i],"<%f,%f,%f>",&x,&y,&z);
		printf("<%f,%f,%f>\n",x,y,z);
		chldir[i - 1] = Vector3(x,y,z);
	}
	
	maxlen = 0;
	aubuffer[0] = 0;
	aubuffer[1] = 0;
	aubuffer[2] = 0;
		
	fp = fopen("aurender.txt","r");
	if(fp == 0)
	{
		fprintf(stderr,"Cannot open file aurender.txt!\n");
		exit(-1);
	}
	while(!feof(fp))
	{
		fgets(buffer,1024,fp);
		cp = strtok(buffer," \t\n");
		if(cp)
		{
			strcpy(soundfile,cp);
			cp = strtok(0," \t\n");
			if(!cp) errorfile();
			channel = atoi(cp);
			if(channel < 0)
				continue;
			if(create_stereo)
				file = channel & 0xFE;
			else
				file = channel & 0xFF;
				
			cp = strtok(0," \t\n");
			if(!cp) errorfile();
			startms = atoi(cp);
			if(startms < 0)
				continue;
			cp = strtok(0," \t\n");
			if(!cp) errorfile();
			offsetms = atoi(cp);
			if(offsetms < 0)
				continue;
			cp = strtok(0," \t\n");
			if(!cp) errorfile();
			timems = atoi(cp);
			if(timems < 0)
				continue;
			cp = strtok(0," \t\n");
			if(!cp) errorfile();
			sscanf(cp,"<%g,%g,%g>",&f[0],&f[1],&f[2]);
			direction[0] = f[0];
			direction[1] = f[1];
			direction[2] = f[2];
			cp = strtok(0,"\n");
			filter = cp;
			printf("%s on #%i at %ims with %ims for %ims <%g,%g,%g> [%s]\n",
				soundfile,
				channel,
				startms,
				offsetms,
				timems,
				direction[0],direction[1],direction[2],
				filter);
			
			// vol = 1 / (log(1 + d) + 1)

			scale = 1 / (log(1 + sqr(direction.length() / 100)) + 1);
			if(chldir[channel].length() > 0)
			{
				v1 = chldir[channel];
				v2 = direction;
				v1.normalize();
				v2.normalize();
				ang = v1.scalarprod(v2);
				vol = scale * (1.1 - ang) / 2.1;
			}
			else
				vol = scale;
			
#ifdef DEBUG
			printf("d:<%g,%g,%g> e:<%g,%g,%g> = %g (%g)\n",
				direction[0],
				direction[1],
				direction[2],
				chldir[channel][0],
				chldir[channel][1],
				chldir[channel][2],
				vol,
				ang);
#endif

			if(filter)
				sprintf(command,"sox %s -v %g -t .raw -s -w -r 44100 tmp.raw %s",soundfile,vol,filter);
			else
				sprintf(command,"sox %s -v %g -t .raw -s -w -r 44100 tmp.raw",soundfile,vol);
			
			system(command);
			
			maxlen = MAX(maxlen,(44100 * (startms + timems)) / 1000);
			
			if(chfp[file] == 0)
			{
				char	tmpstr[256];
				char	buffer[2];
				
				buffer[0] = 0;
				buffer[1] = 0;
				
				sprintf(tmpstr,"channel%0.3i.raw",file);
				chfp[file] = fopen(tmpstr,"w+");
				for(i = 0;i < maxlen * (create_stereo?2:1);i++)
					fwrite(buffer,1,2,chfp[file]);
			}
			
			samples = (44100 * timems) / 1000;
			
			aubuffer[0] = (char*)realloc(aubuffer[0],samples * 2);
			aubuffer[1] = (char*)realloc(aubuffer[1],samples * 2 * (create_stereo?2:1));
			aubuffer[2] = (char*)realloc(aubuffer[2],samples * 2 * (create_stereo?2:1));
			
			fp2 = fopen("tmp.raw","rb");
			fseek(fp2,(44100 * offsetms) / 1000 * 2,SEEK_SET);
			fread(aubuffer[0],2,samples,fp2);
			fclose(fp2);
			
			fseek(chfp[file],(44100 * startms) / 1000 * 2 * (create_stereo?2:1),SEEK_SET);
			fread(aubuffer[1],2 * (create_stereo?2:1),samples,chfp[file]);
			
			for(i = 0;i < samples;i++)
			{
				if(create_stereo)
				{
					if((channel & 1) == 0)
					{
						((short*)aubuffer[2])[i * 2] =
							((short*)aubuffer[0])[i] +
							((short*)aubuffer[1])[i * 2];
						((short*)aubuffer[2])[i * 2 + 1] =
							((short*)aubuffer[1])[i * 2 + 1];
					}
					else
					{
						((short*)aubuffer[2])[i * 2] =
							((short*)aubuffer[1])[i * 2];
						((short*)aubuffer[2])[i * 2 + 1] =
							((short*)aubuffer[0])[i] +
							((short*)aubuffer[1])[i * 2 + 1];
					}
				}
				else
				{
					((short*)aubuffer[2])[i] =
						((short*)aubuffer[0])[i] +
						((short*)aubuffer[1])[i];
				}
			}
				
			fseek(chfp[file],(44100 * startms) / 1000 * 2 * (create_stereo?2:1),SEEK_SET);
			fwrite(aubuffer[2],2 * (create_stereo?2:1),samples,chfp[file]);
			fflush(chfp[file]);
 			system("rm -f tmp.raw");
		}
	}
	fclose(fp);
	
	for(i = 0;i < 256;i++)
	{
		if(chfp[i] != 0)
		{
			char	tmpstr[256];

			fclose(chfp[i]);
			
			sprintf(tmpstr,"sox -t .raw -s -w -r 44100 %s channel%0.3i.raw -t .wav channel%0.3i.wav",
				(create_stereo?"-c 2":""),
				i,
				i);
			system(tmpstr);
			
		}
	}
	
	if(aubuffer[0])
		free(aubuffer[0]);
		
	if(aubuffer[1])
		free(aubuffer[1]);
		
	if(aubuffer[2])
		free(aubuffer[2]);
	
		
		
	exit(0);	
}


