/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** k4ded.cpp
*/
#include "k4ded.h"
#include <pvm3.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>

int x1=0,y1=0,x2=123,y2=345,qual=0,w=12,h=13;

char *calc();
void cleanup();
int length;

int main()
{
int mytid;
int masterid;
int mid,j;
FILE *file;
char *data;
int lt[7];	
int t1;

	mytid=pvm_mytid();
	mid=pvm_recv(-1,1);

	pvm_bufinfo(mid,(int*)0,(int*)0,&masterid);
	pvm_unpackf("%d%d%d%d%d%d%d%d",&length,&x1,&y1,&x2,&y2,&w,&h,&qual);

	pvm_recv(-1,2);
        data=(char *)malloc(length);
	pvm_bufinfo(pvm_getrbuf(),&j,(int*)0,&masterid);
	pvm_upkbyte(data,length,1);		
         	
	if (data) {

		file=fopen("/tmp/pvmrender.pov","w");
		if (file) {
			fwrite(data,1,length,file);
			fclose(file);
			free(data);
                	//t1=time();
			data=calc();
			if (data) {
				lt[0]=length;
				lt[1]=0; //time()-t1;
				lt[2]=x1;
				lt[3]=y1;
				lt[4]=x2;
				lt[5]=y2;
				pvm_initsend(PvmDataDefault);
				pvm_pkint(lt,6,1);
				pvm_send(masterid,20);

				pvm_initsend(PvmDataDefault);
				pvm_packf("%+ %*c", PvmDataDefault,length,data);
				pvm_send(masterid,21);	
				free(data);
			}
		}
	}

	pvm_exit();
	return 0;
}


void cleanup()
{
char 	*args1[2];
char 	*args2[2];
int status,cid,i;

	for (i=0;i<2;i++) args1[i]=(char*)malloc(20);		
	for (i=0;i<2;i++) args2[i]=(char*)malloc(20);		
	args1[0]="rm";
	args1[1]="/tmp/pvmrender.pov";
	args1[2]=NULL;
	args2[0]="rm";
	args2[1]="/tmp/pvmrender.ppm";
	args2[2]=NULL;

	switch((cid=fork())) {
		case 0:
			execvp("rm",args1);
		break;
		default:
			waitpid(cid,&status,0);
		break;
	}

	switch((cid=fork())) {
		case 0:
			execvp("rm",args2);
		break;
		default:
			waitpid(cid,&status,0);
		break;
	}

}

char* calc()
{
int i;
char 	*args[12];
int	cid,status;
FILE *file;
char *picdata;

	for (i=0;i<11;i++) args[i]=(char*)malloc(128);	
	args[0]="povray";
	sprintf(args[1],"+I/tmp/pvmrender.pov");
	sprintf(args[2],"+SC%d",x1);
	sprintf(args[3],"+SR%d",y1);
	sprintf(args[4],"+EC%d",x2);
	sprintf(args[5],"+ER%d",y2);
	sprintf(args[6],"+Q%d",qual);
	sprintf(args[7],"+FP");
	sprintf(args[8],"+O/tmp/pvmrender.ppm");
	sprintf(args[9],"+W%d",w);
	sprintf(args[10],"+H%d",h);
	args[11]=NULL;
	
	switch((cid=fork())) {
		case 0:
			execvp("povray",args);
		break;
		default:
			waitpid(cid,&status,0);
		break;
	}
	picdata=NULL;
	file=fopen("/tmp/pvmrender.ppm","r");
	if (file) {
		fseek(file,0,SEEK_END);
		length=ftell(file);
		fseek(file,0,SEEK_SET);
		picdata=(char *)malloc(length);
		if (picdata) {	
			fread(picdata,1,length,file);
		}
		fclose(file);
	}
	return picdata;
}
