/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** list.h
*/
#ifndef __LIST__
#define __LIST__

#include <stdio.h>
#include <stdlib.h>

#include "simplelist.h"


template<class type>
class list : public simplelist<type>
{
public:
	typedef int	(sortfunction)(type,type);

protected:
	int		pos,last,d_unique;

public:
	list();
	list(const type &); 
	list(const list<type>&);
	list(const simplelist<type>&);
	~list();

	int		unique();
	void		setUnique(int f);

	int		insert(const type l);				// Element an aktueller Position einfgen
	int		insertAt(const type l,int pos);			// Element an Position pos einfgen
	int		append(const type l);
	int		append(const list<type>);
	type		deleteCurrent();				// Aktuelles Element lschen
	int		deleteAt(int);					// Element an Position lschen

	int		operator==(const list<type>);			// Element anfgen
	int		operator+=(const type l);			// Element anfgen
	int		operator+=(const simplelist<type>);		// Liste anfgen
	int		operator+=(const list<type>);			// Liste anfgen
	list<type>	&operator=(const simplelist<type>);		// gleich
	list<type>	&operator=(const list<type>);			// gleich
	list<type>	operator+(const type) const;			// plus
	list<type>	operator+(const simplelist<type>) const;	// plus
	list<type>	operator+(const list<type>) const;		// plus

	type		&operator--();					// Eine Position zurck, NULL=Kettenanfang erreicht
	type		&operator++();					// Eine Position vor, NULL=Kettenende erreicht
	type		&getFirst();
	type		&getLast();
	type		&getCurrent();
	type		&at(int);
	const type	at(int) const;
	type		&operator[](int);
	const type	operator[](int) const;
	type		*operator()(int) const;
	type		*atPtr(int) const;
	int		compare(const list<type>);			// Element anfgen

	int		setPosition(int);

	int		find(const type);
	int		find(const type) const;

//	list<list<type> >	power();
	void		sort(sortfunction);
private:
	void		heapsort(sortfunction,int,int);
	void		reheap(sortfunction,int,int);

};

/*
template<class type>
list<list<type> >	list<type>::power()
{
	list<list<type> >	pl;
	list<type>		*tl;
	int			i,t,f;

	pl.setUnique(1);
	tl = new list<type>();
	tl->setUnique(1);

	pl.empty();
	pl += *tl;
	f = 1;
	for(i = 0;i < length();i++)
	{
		tl = new list<type>();
		tl->setUnique(1);
		tl->empty();
		tl->append(at(i));
		pl += *tl;
		f *= (1 + i);
	}

	for(t = 1;t < length();t++)
	{
		printf("t = %i l = %i\n",t,pl.length());
		tl = new list<type>();
		tl->setUnique(1);
		tl->empty();
		for(i = t;i < pl.length();i++)
		{
			tl->append(pl[t + i]);
		}
		pl += *tl;
	}
	
	return pl;
}
*/

template<class type>
int	list<type>::operator==(const list<type> l)
{
	int		i;

	if(length() != l.length())
		return 0;

	for(i = 0;i < l.length();i++)
	{
		if(find(l[i]) < 0)
			return 0;
	}

	return 1;
}

template<class type>
int	list<type>::compare(const list<type> l)
{
	int		i;

	if(length() != l.length())
		return 0;

	for(i = 0;i < l.length();i++)
	{
		if(find(l[i]) < 0)
			return 0;
	}

	return 1;
}

template<class type>
int	list<type>::operator+=(const type l)
{
	return append(l);
}

template<class type>
int	list<type>::operator+=(const list<type> l)
{
	int		i;
	
	for(i = 0;i < l.length();i++)
	{
		append(l[i]);
	}

	return 0;
}

template<class type>
int	list<type>::operator+=(const simplelist<type> l)
{
	int		i;
	
	for(i = 0;i < l.length();i++)
	{
		append(l[i]);
	}

	return 0;
}

template<class type>
list<type>	&list<type>::operator=(const simplelist<type> l)
{
	int		i;

	empty();	
	for(i = 0;i < l.length();i++)
	{
		append(l[i]);
	}

	return *this;
}

template<class type>
list<type>	&list<type>::operator=(const list<type> l)
{
	int		i;

	empty();	
	for(i = 0;i < l.length();i++)
	{
		append(l[i]);
	}

	return *this;
}

template<class type>
list<type>	list<type>::operator+(const type l) const
{
	simplelist<type>	tmp = *this;

	tmp.append(l);

	return tmp;
}

template<class type>
list<type>	list<type>::operator+(const simplelist<type> l) const
{
	simplelist<type>	tmp(*this);
	int		i;

	for(i = 0;i < l.length();i++)
	{
		tmp.append(l[i]);
	}

	return tmp;
}

template<class type>
list<type>	list<type>::operator+(const list<type> l) const
{
	simplelist<type>	tmp(*this);
	int		i;

	for(i = 0;i < l.length();i++)
	{
		tmp.append(l[i]);
	}

	return tmp;
}


template<class type>
list<type>::list() :
	simplelist()
{
	size=0;
	pos=last=0;
	lptr=0;
	d_unique = 0;
}

template<class type>
list<type>::list(const type &l) :
	simplelist()
{
	size=0;
	pos=last=0;
	lptr=0;
	d_unique = 0;

	append(l);
}

template<class type>
list<type>::list(const list<type> &lc) :
	simplelist(lc)
{
	pos = lc.pos;
	last = lc.last;
	d_unique = lc.d_unique;
}

template<class type>
list<type>::list(const simplelist<type> &lc) :
	simplelist(lc)
{
	pos = 0;
	last = 0;
	d_unique = 0;
}

template<class type>
list<type>::~list()
{
	empty();
}

template<class type>
int		list<type>::unique()
{
	return d_unique;
}

template<class type>
void		list<type>::setUnique(int f)
{
	d_unique = f;
}

template<class type>
int	list<type>::deleteAt(int n)
{
	if(setPosition(n) == n)
	{
		deleteCurrent();

		return 0;
	}

	return -1;
}

template<class type>
type	list<type>::deleteCurrent()
{
	int		i;
	type		elem;

	if(isEmpty()) return errorvalue;

	elem = lptr[pos];

	for(i=pos;i<size;i++)
		lptr[i]=lptr[i+1];
	size--;
	lptr=(type*)realloc(lptr,size * sizeof(type));

	if(pos >= size) pos = size - 1;

	if(lptr == 0 && size != 0)
	{
		// fehler

		size = 0;
		pos = 0;

		return elem;
	}

	return elem;
}

template<class type>
type	&list<type>::operator++()
{
	if(pos >= size - 1 || isEmpty())
	{
		// fehler ???
	 	return errorvalue;
	}

	return(lptr[++pos]);
}

template<class type>
type	&list<type>::operator--()
{
	if(pos <= 1 || isEmpty())
	{
		// fehler ???
	 	return errorvalue;
	}

	return(lptr[--pos]);
}

template<class type>
int	list<type>::insert(const type l)
{
int i;
	printf("inserting...\n");
/*
	if(unique())
	{
		if(find(l) >= 0)
			return 0;
	}
*/

	lptr = (type*)realloc(lptr,(size + 1) * sizeof(type));
	if(lptr)
	{
		for(i=pos;i<size;i++)
		{
			printf("%d\n",i);
			lptr[i+1] = lptr[i];
		}
		lptr[pos]=l;
		size++;
		return 0;
	}

	return -1;
}

template<class type>
int	list<type>::append(const type l)
{
	if(unique())
	{
		if(find(l) >= 0)
			return 0;
	}
	lptr = (type *)realloc(lptr,(size + 1) * sizeof(type));
	if(lptr)
	{
		lptr[size] = l;
		pos = size;
		size++;

		return 0;
	}

	size = 0;

	return -1;
}

template<class type>
int	list<type>::append(const list<type> l)
{
	int		i,e;

	for(i = 0;i < l.length();i++)
	{
		if((e = append(l[i])) != 0)
			return e;
	}

	return 0;
}

template<class type>
int	list<type>::insertAt(const type l,int p)
{
	if(setPosition(p) == p)
		return insert(l);

	return -1;
}

template<class type>
type	&list<type>::getFirst()
{
	if(isEmpty()) return errorvalue;

	pos = 0;
	return lptr[pos];
}

template<class type>
type	&list<type>::getLast()
{
	if(isEmpty()) return errorvalue;

	pos = size  - 1;
	return lptr[pos];
}

template<class type>
type	&list<type>::getCurrent()
{
	if(isEmpty()) return errorvalue;

	return lptr[pos];
}

template<class type>
int	list<type>::find(const type x)
{
	int	t;

	if(isEmpty()) return -1;

	for(t = 0;t < size;t++)
		if(lptr[t] == x) return (pos = t);

	return -1;
}

template<class type>
int	list<type>::find(const type x) const
{
	int	t;

	if(isEmpty()) return -1;

	for(t = 0;t < size;t++)
		if(lptr[t] == (type)x) return t;

	return -1;
}

template<class type>
type	&list<type>::at(int t)
{
	if(isEmpty()) return errorvalue;

	if(t < 0 || t >= size) return errorvalue;

	return lptr[t];
}

template<class type>
const type	list<type>::at(int t) const 
{
	if(isEmpty())
		return errorvalue;

	if(t < 0 || t >= size)
		return errorvalue;

	return lptr[t];
}

template<class type>
type	*list<type>::atPtr(int t) const
{
	if(isEmpty()) return 0;

	if(t < 0 || t >= size) return 0;

	return &lptr[t];
}

template<class type>
type	*list<type>::operator()(int t) const
{
	return atPtr(t);
}

template<class type>
type	&list<type>::operator[](int t)
{
	return at(t);
}

template<class type>
const type	list<type>::operator[](int t) const
{
	return at(t);
}

template<class type>
int	list<type>::setPosition(int p)
{
	if(isEmpty()) return -1;

	if(p < 0) p = 0;
	if(p >= size) p = size - 1;

	pos = p;

	return pos;
}

template<class type>
void	list<type>::sort(sortfunction sf)
{
	if(!sf) return;

	heapsort(sf,0,size - 1);
}

template<class type>
void	list<type>::heapsort(sortfunction sf,int l,int r)
{
	int	j,n,k;
	
	n = r - l;
	
	for(j = n / 2;j >= 1;j--)
		reheap(sf,j,n);
		
	for(k = n;k >= 2;k--)
	{
		swap(l - 1 + (k),l - 1 + (1));
		reheap(sf,l - 1 + (1),l - 1 + (k - 1));
	}
}

template<class type>
void	list<type>::reheap(sortfunction sf,int lb,int rb)
{
	int		j,l,k;
	int		b[1 + (rb - lb) / 2];
	type		x;
		
	k = rb - lb;
	
	b[0] = 1;
	j = 1;
	l = 0;
	while(2 * j + 1 < k)
	{
		if((sf)(lptr[lb - 1 + (2 * j)],lptr[lb - 1 + (2 * j + 1)]) < 0)
		{
			j = 2 * j;
		}
		else
		{
			j = 2 * j + 1;
		}
		l = l + 1;
		b[l] = j;
	}
	if(2 * j == k)
	{
		j = k;
		l = l + 1;
		b[l] = j;
	}
	
	while((sf)(lptr[lb - 1 + (b[l])],lptr[lb - 1 + (1)]) > 0)
		l = l - 1;
		
	x = lptr[lb - 1 + (1)];
	for(k = 1;k <= l;k++)
	{
		lptr[lb - 1 + (b[k - 1])] = lptr[lb - 1 + (b[k])];
	}
	lptr[lb - 1 + (b[l])] = x;
}


#endif

