/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** chunk.h
*/
#ifndef __CHUNK_H__
#define __CHUNK_H__

#include "matmath.h"
#include "media.h"
#include "machine.h"


//if there is one of thses macros used include stdio
#include <stdio.h>

class chunk
{
protected:
	int	pos,start;
	media	*mptr;
	FILE	*chfp;

public:
	chunk();
	chunk(media*);

	void		setFile(FILE *fp);
	void		setMedia(media*);

	void		readChunk(char *n,int &l);
	void		rejectChunk();
	
	void		writeChunk(const char *cn);
	void		writeChunkLen(int l);
	void		writeChunkLen();
	int		getChunkLen(int l);

	char		*readName();
	char		*readNameChunk();
	double		readDouble();
	int		readInt();
	bool		readBool();
	Vector3		readVector();
	Vector3		readVector3();
	Vector2		readVector2();
	Vector4		readVector4();

	int		writeName(const char *n);
	int		writeNameChunk(const char *n);
	int		writeDouble(double);
	int		writeInt(int);
	int		writeBool(bool);
	int		writeVector(Vector3);
	int		writeVector(Vector2);
	int		writeVector(Vector4);
};


#endif


