/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** transformwidget.h
*/
#ifndef __TRANSFORMWIDGET_H__
#define __TRANSFORMWIDGET_H__

#include <qwidget.h>
#include <qlined.h>
#include <qlabel.h>

#include <matmath.h>
#include <misc.h>

#include "vectorwidget.h"

class TransformWidget : public QWidget
{
Q_OBJECT
protected:
	QLabel		*la[3];
        VectorWidget	*vw[3];

public:
	TransformWidget(QWidget *p,char *n);
	~TransformWidget();

	void	layout();
	QSize	sizeHint();

public slots:
	void	load(Vector3 sv,Vector3 rv,Vector3 tv);
	void	save(Vector3 &sv,Vector3 &rv,Vector3 &tv);
	
signals:
	void	changed();
};

#endif



