/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** spinbox.h
*/
#ifndef __SPINBOX_H__
#define __SPINBOX_H__

#include <qwidget.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qvalidator.h>
#include <qlabel.h>

class	 SpinBox: public QWidget
{
Q_OBJECT

protected:
	double			value,step,topV,downV;
	int			stepcount;
	QPushButton		*up,*down;
	QLineEdit		*edit;
	QIntValidator		*qiv;
	QDoubleValidator	*qdv;	
	QLabel			*label;
	int			tab;
	double			origStep;

public:
	SpinBox(QWidget *parent,const char *name,double value=0.0);
	~SpinBox();

	void 		setLabel(char *);
	void 		DownTopValue(double,double);
	void		switchToIntMode();
	void		switchToDoubleMode();
	virtual QSize	sizeHint();
	void		paintEvent(QPaintEvent *);
	int		layout(SpinBox *s1,SpinBox *s2=0,SpinBox *s3=0,SpinBox *s4=0,SpinBox *s5=0);
	int 		getLabelLength();
	void		setTab(int);

	double 		getValue();
	void		setStep(double);
	double 		getStep();
	void		setStep(int);

public slots:	
	void 		setValue(double);
	void 		setEnabled(bool);
	
protected slots:
	void 		upClicked();
	void 		downClicked();
	void 		released();
	void 		newText(const char *);

signals:
	void 		changed();
	void 		valueChanged();
	void 		sizeChanged();
	
protected:
	void		layout();
};


#endif

