/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** percentwidget.cpp
*/

#include <klocale.h>
#include "percentwidget.h"
#include "percentwidget.moc"
#include "misc.h"
#include <stdio.h>
#include <qslider.h>

PercentWidget::PercentWidget(QWidget *parent,const char *name,double v) :
	QWidget(parent,name)
{

	value=v;

	slider=new QSlider(this);

	slider->setRange(0,100);
	slider->setSteps(1,1);
	slider->setOrientation(QSlider::Horizontal);
	slider->setValue( (int)(v*100) );

	label=new QLabel(name,this);
	valuel=new QLabel(this);
	
	connect(slider,SIGNAL(valueChanged(int)),this,SLOT(changed(int)) );	

}

PercentWidget::~PercentWidget()
{
	if(label) delete label;
	if(valuel) delete valuel;
	if (slider) delete slider;
}

int PercentWidget::getLabelWidth()
{
	if(label) return label->sizeHint().width();
	else return 0;
}

void PercentWidget::setTab(int t)
{
	tab=t;
}

int PercentWidget::layout(PercentWidget *w1,PercentWidget *w2,PercentWidget *w3,PercentWidget *w4)
{
int wmax=0;
	if (w1) wmax=MAX(wmax,w1->getLabelWidth() );
	if (w2) wmax=MAX(wmax,w2->getLabelWidth() );
	if (w3) wmax=MAX(wmax,w3->getLabelWidth() );
	if (w4) wmax=MAX(wmax,w4->getLabelWidth() );

	if (w1) w1->setTab(wmax);
	if (w2) w2->setTab(wmax);
	if (w3) w3->setTab(wmax);
	if (w4) w4->setTab(wmax);

	return wmax;
}

void PercentWidget::changed(int x)
{
        QString buf;

	value=(double)(x/100.0);
	buf.setNum(value);
	valuel->setText(buf);
	emit valueChanged();
}

double PercentWidget::getValue()
{
	return value;
}

void PercentWidget::setValue(double v)
{
        QString buf;

	value=v;
	buf.setNum(value);
	valuel->setText(buf);
}

QSize PercentWidget::sizeHint()
{
	paintEvent(NULL);
	return qs;
}

void PercentWidget::paintEvent(QPaintEvent* qp)
{
        QString buf;
	int h,w,x=0;

	buf.setNum(value);
	valuel->setText( buf);

        w=label->sizeHint().width();
	if (tab!=0) w=tab;
	h=label->sizeHint().height();

	label->setGeometry(0,0,w,h);
	x+=w+5;
	slider->setGeometry(x,0,100,h);
	x+=105;

	w=valuel->sizeHint().width()+20;	
	valuel->setGeometry(x,0,w,h);	
        x+=w;

	qs.setWidth(x);
	qs.setHeight(h*2);
	if (qp) QWidget::paintEvent(qp);

}
