/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** getfilewidget.cpp
*/
#include "getfilewidget.h"
#include "getfilewidget.moc"

#include <kapp.h>

#include <stdio.h>

#include <misc.h>
#include <qimage.h>

#include <qimageio.h>
#include <qpngio.h>

GetFileWidget::GetFileWidget(QWidget *parent,const char *name,QString path,int x) :
	QWidget(parent,name)
{

#if (USE_QIMAGEIO == 1)
	qInitImageIO();
#endif
	labelwidth = -1;
	start = path;
	GetType = x;
	filenamelabel = new QLabel(this);
	filenamelabel->setAutoResize(true);
	filenamelabel->setText(name);

	filename = new QLineEdit(this);
	filename->setText(path);

	switch(GetType)
	{
		case 0:
#if (USE_QTOOLTIP == 1)
			QToolTip::add(filename,i18n("Enter a filename or drop a file here") );
#endif
		break;
		case 1:
		{
			QString types="";
#if (USE_QIMAGEIO == 1)
                	QStrList fmt=QImage::inputFormats();
		
                        for (const char *f=fmt.first();f;f=fmt.next())
                        {
				types+=f+(QString)" ";				
			}
#else
				types=(QString)"gif tga iff ppm pgm png\n"+i18n("There will be no preview, because this Version of K4DE can't use qimageio");
#endif
#if (USE_QTOOLTIP == 1)
			QToolTip::add(filename,i18n("Enter a filename or drop an imagefile here\nSupported:"+types) );
#endif
		}
		break;		
		case 2:
#if (USE_QTOOLTIP == 1)
			QToolTip::add(filename,i18n("Enter or drop a directory here") );
#endif
		break;
	}

	FileDialogBt = new QPushButton(this);
	FileDialogBt->setAutoResize(true);
	FileDialogBt->setText("...");
	FileDialogBt->setToggleButton(false);
#if (USE_QTOOLTIP == 1)
	QToolTip::add(FileDialogBt,i18n("Pop up a Filedialog") );
#endif
	
	clearfile = new QPushButton(this);
	clearfile->setAutoResize(true);
	clearfile->setText(i18n("clear") );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(clearfile,i18n("Clear filename"));
#endif

	dnd = new KDNDDropZone(this, DndText);

	connect(FileDialogBt,SIGNAL(clicked()),this,SLOT(getFile()));
	connect(clearfile,SIGNAL(clicked()),this,SLOT(clearFile()));
	connect(dnd,SIGNAL(dropAction(KDNDDropZone *)),this,SLOT(dropped(KDNDDropZone *)));
	
//	paintEvent(0);
}



GetFileWidget::~GetFileWidget()
{
	if (FileDialogBt) delete FileDialogBt;
	if (clearfile) delete clearfile;
	if (dnd) delete dnd;
}

void GetFileWidget::paintEvent(QPaintEvent *qp)
{
	int	w,wl,wb1,wb2,wt;
	int	h;
	int	x;

	if(labelwidth >= 0)
		wl = labelwidth;
	else
		wl = filenamelabel->sizeHint().width();
		
	wb1 = FileDialogBt->sizeHint().width();
	wb2 = clearfile->sizeHint().width();
	
	wt = width() - 15 - wb1 - wb2 - wl;
	x = 0;
	h = 25;
	w = wl;
	
	filenamelabel->setGeometry(x,0,w,h);
      	
	x += w + 5;
	w = wt;
	filename->setGeometry(x,0,w,h);
	
	x += w + 5;
	w = wb1;
	FileDialogBt->setGeometry(x,0,w,h);

	x += w + 5;
	w = wb2-5;
	clearfile->setGeometry(x,0,w,h);

	if(qp)
		QWidget::paintEvent(qp);
}

QSize 	GetFileWidget::sizeHint()
{
	int		w,h;
	int		wl,wt,wb1,wb2;

	if(labelwidth >= 0)
		wl = labelwidth;
	else
		wl = filenamelabel->sizeHint().width();
		
	wb1 = FileDialogBt->sizeHint().width();
	wb2 = clearfile->sizeHint().width();
	
	wt = MAX(wb2 + wl,filename->sizeHint().width());
	
	w = wl + 5 + wt + 5 + wb1 + 5 + wb2;
	h = 25;
	
	qs.setWidth(w+5);
	qs.setHeight(h);
	
	return qs;
}

void	GetFileWidget::getFile()
{
	QString		qs;
	KFileDialog	*kfd;

	qs = filename->text();
	if(qs != "" && !qs.isEmpty() && !qs.isNull())
		start = qs;

	switch(GetType)
	{
		case 0:
			kfd = new KFileDialog(".");
			qs = kfd->getOpenFileName(start,"*",this,0);
			if (qs.isEmpty()==false) filename->setText(qs);
			if (kfd) delete kfd;

		break;
		case 1:
		{
			QString types = "";
			
			kfd = new KFileDialog(".");
			
#if (USE_QIMAGEIO == 1)
			QStrList fmt=QImage::inputFormats();
                        for(const char *f = fmt.first();f;f = fmt.next())
                        {
				QString tmp=f;
				types += (QString)"*." + tmp + " ";				
				types += (QString)"*." + tmp.lower() + " ";				
			}
#else
			types = "*.gif *.GIF *.tga *.TGA *.iff *.IFF *.ppm *.PPM *.png *.PNG";
#endif
			qs = kfd->getOpenFileName(start,types,this,0);
			if(!qs.isEmpty())
				filename->setText(qs);
			
			//  ***  das ist unsinn: an dieser stelle ist kfd auf jeden fall != 0!!!
			if (kfd) delete kfd;
		}
		break;
		case 2:
			kfd = new KFileDialog("");
			qs = kfd->getDirectory(start);
			if (qs.isEmpty()==false) filename->setText(qs);
			if (kfd) delete kfd;

		break;

	}
	//filename->setText(qs);
	emit changed();
}

void	GetFileWidget::clearFile()
{
	filename->setText("");
}

QString	GetFileWidget::getFilename()
{
	QString		qstr(filename->text());
	
	return qstr;
}

const char	*GetFileWidget::text() const
{
	return filename->text();
}

void	GetFileWidget::setFilename(QString n)
{
	filename->setText(n);
	emit changed();
}

void	GetFileWidget::setText(const char *n)
{
	filename->setText(n);
}

QString	GetFileWidget::getImageType()
{
QString tmp;
	tmp=getFilename();
	return tmp.right(3);
}

void GetFileWidget::dropped(KDNDDropZone *d)
{
	char	data[256];
	FILE	*f;
	
	printf("Dropped Data:%s\n",(char*)d->getData());	
	if(strncmp("file:",d->getData(),5) != 0)
	{
		QMessageBox qm(i18n("Error"),i18n("At this time you can only drop files"),QMessageBox::Warning, QMessageBox::Cancel,0,0);
		qm.exec();
	}
	else
	{
		strcpy(data,d->getData() + 5);
		data[strlen(d->getData() + 5)] = 0;

		f = fopen(data,"r");
		if(f != 0)
		{
			filename->setText(data);
			fclose(f);
		}
		else
		{
			QMessageBox qm(i18n("Error"),i18n("The File could not be opened...\n(Maybe you dropped more as one file)"),QMessageBox::Warning, QMessageBox::Cancel,0,0);
			qm.exec();
		}
	}
	emit changed();
}

void	GetFileWidget::setLabelWidth(int w)
{
	labelwidth = w;
	paintEvent(0);
}

int	GetFileWidget::getLabelWidthHint()
{
	return filenamelabel->sizeHint().width();
}



		
