/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturedialog.cpp
*/
#include "texturedialog.h"
#include "texturedialog.moc"

#include <kapp.h>

TextureWidget::TextureWidget(QWidget *parent,texture *t) :
	TextureWidgetBase(parent,"TextureWidget")
{
	txt=t;

	tbasew=new TextureBaseWidget(this,t );	
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}


TextureWidget::~TextureWidget()
{
	if (tbasew) delete tbasew;
}

void TextureWidget::getValue()
{
	tbasew->getTextureBase();
}

QSize TextureWidget::sizeHint() const
{
	return qs;
}

void TextureWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0;

	tbasew->setGeometry(10,10,w,h);
	y+=h+15;

	qs.setWidth(w+15);
	qs.setHeight(y+15);
	if (qp) QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

TextureDialog::TextureDialog(QWidget *parent,texture *t) :
	QDialog(parent,"MaterialDialog",true)
{
	setCaption(i18n("Material") );

	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new TextureWidget(this,t);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );
	
	paintEvent(NULL);
}

TextureDialog::~TextureDialog()
{
	if (pw) delete pw;
	if (ok) delete ok;
	if (cancel) delete cancel;
}


void TextureDialog::cancelPressed()
{
	QDialog::done(0);
}

void TextureDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void TextureDialog::paintEvent(QPaintEvent* qp)
{
 	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	pw->setGeometry(0,0,w,h);
	setMinimumSize(w,h);
	setMaximumSize(w,h);

	if (qp) QDialog::paintEvent(qp);

}

