/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normaldialog.cpp
*/
#include "normaldialog.h"
#include "normaldialog.moc"

#include <kapp.h>

NormalWidget::NormalWidget(QWidget *parent,normal *n) :
	TextureWidgetBase(parent,"NormalWidget")
{
	nor=n;
	pmd=new PatternModifierWidget(this,nor->getMapModifier(),0 );

	usePattern=new QCheckBox(i18n("Use Pattern"),this);
	usePattern->setChecked(nor->getUsePattern());

	connect(pmd,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );
	connect(usePattern,SIGNAL(clicked()),this,SIGNAL(usePatternPressed()) );

	tbasew=new TextureBaseWidget(this,nor );
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}

void	NormalWidget::usePatternPressed()
{
	emit valueChanged();
	if (usePattern->isChecked()) pmd->setEnabled(true);
	else pmd->setEnabled(false);
}


NormalWidget::~NormalWidget()
{
	if (tbasew) delete tbasew;
	if (pmd) delete pmd;
}

void NormalWidget::getValue()
{
	pmd->getPatternModifier();
	tbasew->getTextureBase();
	nor->setUsePattern(usePattern->isChecked() );
}

void NormalWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0,w1=0;

	tbasew->setGeometry(10,10,w,h);
	
	y += h + 15;

	h=usePattern->sizeHint().height();	
	usePattern->setGeometry(10,y,w,h);

	y += h + 10;


	w1=pmd->sizeHint().width();
	h=pmd->sizeHint().height();
        pmd->setGeometry(10,y,w1,h);

	y+=h+10;
	w=MAX(w,w1);	

	
	qs.setWidth(w+10);
	qs.setHeight(y+10);

	if (qp) QWidget::paintEvent(qp);
}

QSize NormalWidget::sizeHint() const
{
	return qs;
}


//----------------------------------------------------------

NormalDialog::NormalDialog(QWidget *parent,normal *n) :
	QDialog(parent,"NormalDialog",true)
{
	setCaption(i18n("Normal"));

	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new NormalWidget(this,n);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}


void NormalDialog::okayPressed()
{  	
	pw->getValue();   //Widgetwerte in Pointer sichern
	QDialog::done(1);
}

void NormalDialog::cancelPressed()
{
	QDialog::done(0);
}

NormalDialog::~NormalDialog()
{
	if (pw) delete pw;
	if (ok) delete ok;
	if (cancel) delete cancel;
}

void NormalDialog::paintEvent(QPaintEvent* qp)
{
 	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	pw->setGeometry(0,0,w,h);

	setMinimumSize(w,h);
	setMaximumSize(w,h);

	if (qp) QDialog::paintEvent(qp);
}




