/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colorwidget.cpp
*/

#include "colorwidget.h"
#include "colorwidget.moc"

#include <kapp.h>

#include <qtooltip.h>

ColorWidget::ColorWidget(QWidget *parent,color *c) :
	TextureWidgetBase(parent,"ColorDialog")
{
	co=c;

	tbasew=new TextureBaseWidget(this,co);
	
	transp=new PercentWidget(this,i18n("Transparency"),c->transparency() );
	filter=new PercentWidget(this,i18n("Filter"),c->filter() );

#if (USE_QTOOLTIP == 1)
	QToolTip::add(transp,i18n("The transparency of this color") );
	QToolTip::add(filter,i18n("") );
#endif

	qc.setRgb( (int)(c->red()*255.0), (int)(c->green()*255.0), (int)(c->blue()*255.0) );
	colorbt=new KColorButton(qc,this);	

#if (USE_QTOOLTIP == 1)
	QToolTip::add(colorbt,i18n("The color of the Element") );
#endif


	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );
	connect(transp,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );
	connect(filter,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );
	connect(colorbt,SIGNAL(changed(const QColor &)),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}




void ColorWidget::getValue()
{
	co->setTransparency(transp->getValue());
	qc=colorbt->color();
   	co->setRed((double)(qc.red()/255.0));
	co->setGreen((double)(qc.green()/255.0));
	co->setBlue((double)(qc.blue()/255.0));
	co->setFilter( filter->getValue() );
	tbasew->getTextureBase();
}

ColorWidget::~ColorWidget()
{
	if (tbasew) delete tbasew;
	if (transp) delete transp;
	if (filter) delete filter;
	if (colorbt) delete colorbt;
}

QSize ColorWidget::sizeHint() const
{
	return qs;
}


void ColorWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();	
int h=tbasew->sizeHint().height();
int y=10,w2,h2;

	printf("paintEvent Called\n");
        tbasew->setGeometry(10,y,w,h);
	y+=h+5;

	colorbt->setGeometry(10,y,40,60);	
	
	transp->layout(transp,filter);

	w2=transp->sizeHint().width();
	h2=transp->sizeHint().height();	
	transp->setGeometry(55,y,w2,h2);
	y+=30;

	w2=filter->sizeHint().width();
	h2=filter->sizeHint().height();	
	filter->setGeometry(55,y,w2,h2);

	y+=35;
	if (w< (55+w2)) w=55+w2;
	qs.setHeight(y);
	qs.setWidth(w);	
		
	if (qp) QWidget::paintEvent(qp);
}
//------------------------------------------------------------------------

ColorDialog::ColorDialog(QWidget *parent,color *c) :
	QDialog(parent,"ColorDialog",true)
{
	setCaption(i18n("Color") );
	
	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new ColorWidget(this,c);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}

ColorDialog::~ColorDialog()
{
	if (ok) delete ok;
	if (cancel) delete cancel;
	if (pw) delete pw;
}

void ColorDialog::cancelPressed()
{
	QDialog::done(0);
}

void ColorDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void ColorDialog::paintEvent(QPaintEvent* qp)
{
	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();
        int w1,h1,w2;
	
	h1=cancel->sizeHint().height();
	w1=cancel->sizeHint().width();
	w2=ok->sizeHint().width();

	cancel->setGeometry(w-w1-5,h+5,w1,h1);
	ok->setGeometry(w-w1-w2-10,h+5,w2,h1);
	pw->setGeometry(0,0,w,h);

	setMinimumSize(w,h);
	setMaximumSize(w,h);

	QDialog::paintEvent(qp);
}