/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** mainwin.h
*/
#ifndef __MAINWIN_H__
#define __MAINWIN_H__

#include "animwidget.h"
//class AnimControlWidget;

#include "../texture/texturelistview.h"

#include "../dialogs/df3wizard.h"

#include "worldtree.h"
#include "viewwidget.h"
#include "viewwin.h"

#include "version.h"

#include <ktmainwindow.h>
#include <ktopwidget.h>
#include <knewpanner.h>
#include <ktoolbar.h>

#include "../texture/texturetoolbar.h"

//#include "../texture/textureview.h"

#define MPopupMenu	QPopupMenu

class TextureView;
class TextureListView;

class MainWin : public KTMainWindow
{
	Q_OBJECT
protected:
	
	WorldTree		*worldtree;
	ViewWidget		*viewwidget;
	AnimControlWidget	*animwidget;
	KNewPanner		*hpanner,*vpanner,*vpanner2;
	TextureView		*tview;
	TextureListView		*tlview;

//	QList<KTMainWindow>	mainviewlist;
	
	QDialog			*t1,*t2;

	MPopupMenu		*Mfile,*Medit,*Mobjects,*Mtools,*Mpov,*Mwindows,*Mhelp;
	MPopupMenu		*Mopenrecent;
	KMenuBar		*mainmenu;
	KToolBar		*tbview,*tbtxtview,*mainbar;
	KStatusBar		*stbar;

	int			mid[70];
	int			tb[10];

	int			changed;
	char			*projectname;

	QString			lastread,lastwrite,lastpov;

public:
	MainWin(char *name = 0L);
	~MainWin();

	virtual QSize	sizeHint() const
	{
		QSize	qs(-1,-1);
		
		return qs;
	};
	
	void	paintEvent(QPaintEvent*);
	void	show();

private:
	void	createRecentMenu();
	void	createMenu();
	void	createWidgets();
 	void	createWindowTitle();
 	void	createStatusBar(QString);
 	
private slots:
	void	createViewWidget();

public slots:
	// Menu File
	void	newClicked();
	void	openClicked();
	void	openRecentClicked(int);
	void	saveClicked();
	void	saveAsClicked();
	void	dumpClicked();
	void	optionsClicked();
	void	quitClicked();

	// Menu Edit
//	void	copyClicked();
//	void	cutClicked();
//	void	editClicked();
//	void	addAnimClicked();
//	void	delAnimClicked();
//	void	editAnimClicked();

	// Menu Objects
	void	addObjectClicked();
	void	addCSGClicked();
	void	addBlobClicked();
	void	addRefClicked();
	void	addSphereClicked();
	void	addCylinderClicked();
	void	addBoxClicked();
	void	addMeshClicked();
	void	addRefPtrClicked();
	void	addConeClicked();
	void	addPlaneClicked();
	void	addTorusClicked();
	void	addTriangleClicked();
	void	addHeightfieldClicked();
	void	addTextClicked();
	void	addScriptClicked();

	void	addLightPointClicked();
	void	addSpotLightClicked();
	void	addAreaLightClicked();
//	void	addLightPointClicked();

	void	addCameraClicked();
	void	addEarClicked();

	// Menu Tools
	void	createMap2MeshClicked();
	void	createRecursivTreeClicked();
	void	createForestClicked();
	void	readDF3Clicked();
	void	createDF3Clicked();

	// Menu POV
	void	exportPOVClicked();
	void 	exportTLibClicked();

	// Menu Windows
	void	toggleWACClicked();
	void 	toggleTCCClicked();
	void 	toggleMainToolBar();
	void 	toggleViewToolBar();
	void 	toggleTextureToolBar();
	void	viewObjectClicked();
	void	newViewClicked();
	void	viewObjectWindowClicked();

	// Menu Help
	void	aboutClicked();
	
	// Toolbar
	void	setViewMode(int);
	void	savePicture();

	// Other slots
	void	exportPOV(const char*);
	void	exportPOV(const char*,int);
	void	exportPOVanim(const char*);
	void	resizedView(int,int);
	void	displayMessage(QString);
	void	setChanged();
	void	autoSavePicture();
	void	deleteViewWin(ViewWin*);
//	void	emptyMainViewList();

signals:
	void	viewMode(int);
	void	projectionMode(int);
	void	axeMode(int);
	void	render(int);
	void	changedProjectName(const char*);
	
// forward signals
	void	changedWorld(world*);
	void	redraw();
	void	changedModel();
	void	changedSelected(base*);
	void	changedViewName();
};

#endif

