/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** preferencedialog.cpp
*/
#include "preferencedialog.h"
#include "preferencedialog.moc"

#include <kapp.h>
#include <misc.h>

#if (USE_PVM == 1)
#include <pvm3.h>
#endif




PreferencesDialog::PreferencesDialog(QWidget *pr) :
	QTabDialog(pr,"Preferences",true)
{
	QColor qc;
	int i;	

	setCaption(i18n("Preferences"));
	qc.setRgb(255,0,0);

	pathpage = new QWidget(this);
	editorpage = new QWidget(this);
	renderpage = new QWidget(this);
	screenpage = new QWidget(this);
	miscpage = new QWidget(this);
	clusterpage=new QWidget(this);

	addTab(pathpage,i18n("Paths"));
	addTab(editorpage,i18n("Editor"));
	addTab(renderpage,i18n("Render"));
	addTab(screenpage,i18n("Screen"));
 	addTab(miscpage,i18n("Misc"));
#ifdef USE_PVM
 	addTab(clusterpage,i18n("PVM"));
#endif

	render1 = new QGroupBox(renderpage);
	render1->setTitle(i18n("Render options") );
	render1->setGeometry(5,5,390,130);

	render2 = new QGroupBox(renderpage);
	render2->setTitle(i18n("Render options (Editor Preview)") );
	render2->setGeometry(5,140,390,130);

	render3 = new QGroupBox(renderpage);
	render3->setTitle(i18n("Render options (Texture Preview)") );
	render3->setGeometry(5,275,390,110);

	DataPathWidget = new GetFileWidget(pathpage,i18n("3D-Data"),prefs.getDataPath(),2);
	DataPathWidget->setGeometry(85,5,280,25);

	TexturePathWidget = new GetFileWidget(pathpage,i18n("Textures"),prefs.getTexturePath(),2);
	TexturePathWidget->setGeometry(85,35,280,25);

	imageMapPathWidget = new GetFileWidget(pathpage,i18n("Imagemaps"),prefs.getImageMapPath(),2);
	imageMapPathWidget->setGeometry(85,65,280,25);

	BumpMapPathWidget = new GetFileWidget(pathpage,i18n("Bumpmaps"),prefs.getBumpMapPath(),2);
	BumpMapPathWidget->setGeometry(85,95,280,25);

	fontPathWidget = new GetFileWidget(pathpage,i18n("Truetypefonts"),prefs.getFontPath(),2);
	fontPathWidget->setGeometry(85,125,280,25);

	heightfieldPathWidget = new GetFileWidget(pathpage,i18n("Heightfields"),prefs.getHeightfieldPath(),2);
	heightfieldPathWidget->setGeometry(85,125,280,25);

	ImagePathWidget = new GetFileWidget(pathpage,i18n("Images"),prefs.getImagePath(),2);
	ImagePathWidget->setGeometry(85,155,280,25);

	AnimationPathWidget = new GetFileWidget(pathpage,i18n("Animations"),prefs.getAnimationPath(),2);
	AnimationPathWidget->setGeometry(85,185,280,25);
	
	TempPathWidget = new GetFileWidget(pathpage,i18n("Temporary"),prefs.getTempPath(),2);
	TempPathWidget->setGeometry(85,215,280,25);

	


	GridColorLabel = new QLabel(editorpage);
	GridColorLabel->setText(i18n("Grid:") );
	GridColorLabel->setGeometry(5,5,90,25);
	GridColor = new KColorButton (qc,editorpage);
	GridColor->setColor(prefs.getGridColor());
	GridColor->setGeometry(100,5,35,25);

	XAxisColorLabel = new QLabel(editorpage);
	XAxisColorLabel->setText(i18n("X-Axes:") );
	XAxisColorLabel->setGeometry(5,35,90,25);
	XAxisColor = new KColorButton (qc,editorpage);
	XAxisColor->setColor(prefs.getXAxisColor());	
	XAxisColor->setGeometry(100,35,35,25);

	YAxisColorLabel = new QLabel(editorpage);
	YAxisColorLabel->setText(i18n("Y-Axes:") );
	YAxisColorLabel->setGeometry(5,65,90,25);
	YAxisColor = new KColorButton (qc,editorpage);
	YAxisColor->setColor(prefs.getYAxisColor());;
	YAxisColor->setGeometry(100,65,35,25);

	ZAxisColorLabel = new QLabel(editorpage);
	ZAxisColorLabel->setText(i18n("Z-Axes:") );
	ZAxisColorLabel->setGeometry(5,95,90,25);
	ZAxisColor = new KColorButton (qc,editorpage);
	ZAxisColor->setColor(prefs.getZAxisColor());;
	ZAxisColor->setGeometry(100,95,35,25);

	BackgroundColorLabel = new QLabel(editorpage);
	BackgroundColorLabel->setText(i18n("Background:") );
	BackgroundColorLabel->setGeometry(5,125,90,25);
	BackgroundColor = new KColorButton (qc,editorpage);	
	BackgroundColor->setColor(prefs.getBackgroundColor());;
	BackgroundColor->setGeometry(100,125,35,25);

	LineColorLabel = new QLabel(editorpage);
	LineColorLabel->setText(i18n("Lines:") );
	LineColorLabel->setGeometry(5,155,90,25);
	LineColor = new KColorButton (qc,editorpage);	
	LineColor->setColor(prefs.getLinesColor());;
	LineColor->setGeometry(100,155,35,25);

	SelectedLineColorLabel = new QLabel(editorpage);
	SelectedLineColorLabel->setText(i18n("selected Lines:") );
	SelectedLineColorLabel->setGeometry(5,185,90,25);
	SelectedLineColor = new KColorButton (qc,editorpage);	
	SelectedLineColor->setColor(prefs.getSelectedLinesColor());;
	SelectedLineColor->setGeometry(100,185,35,25);

	BlobColorLabel = new QLabel(editorpage);
	BlobColorLabel->setText(i18n("Blob:") );
	BlobColorLabel->setGeometry(5,215,90,25);
	BlobColor = new KColorButton (qc,editorpage);	
	BlobColor->setColor(prefs.getBlobColor());
	BlobColor->setGeometry(100,215,35,25);

	BoxColorLabel = new QLabel(editorpage);
	BoxColorLabel->setText(i18n("Boxes:") );
	BoxColorLabel->setGeometry(5,245,90,25);
	BoxColor = new KColorButton (qc,editorpage);
	BoxColor->setColor(prefs.getBoxColor());
	BoxColor->setGeometry(100,245,35,25);

	LetterXColorLabel = new QLabel(editorpage);
	LetterXColorLabel->setText(i18n("X-Label:") );
	LetterXColorLabel->setGeometry(150,35,65,25);
	LetterXColor = new KColorButton (qc,editorpage);
	LetterXColor->setColor(prefs.getLetterXColor());
	LetterXColor->setGeometry(220,35,35,25);

	LetterYColorLabel = new QLabel(editorpage);
	LetterYColorLabel->setText(i18n("Y-Label:") );
	LetterYColorLabel->setGeometry(150,65,65,25);
	LetterYColor = new KColorButton (qc,editorpage);
	LetterYColor->setColor(prefs.getLetterYColor());
	LetterYColor->setGeometry(220,65,35,25);

	LetterZColorLabel = new QLabel(editorpage);
	LetterZColorLabel->setText(i18n("Z-Label:") );
	LetterZColorLabel->setGeometry(150,95,65,25);
	LetterZColor = new KColorButton (qc,editorpage);
	LetterZColor->setColor(prefs.getLetterZColor());
	LetterZColor->setGeometry(220,95,35,25);

	DrawAxisCheckBox = new QCheckBox(editorpage);
	DrawAxisCheckBox->setText(i18n("Draw Axis") );
	DrawAxisCheckBox->setGeometry(5,275,80,25);
	DrawAxisCheckBox->setChecked(prefs.getDrawAxes() );

//Renderer fr richtige Berechnung

	RenderProgram = new GetFileWidget(render1,i18n("Program") ,prefs.getRenderProgram(),0);
	RenderProgram->setGeometry(5,15,390,25);

	RenderParams = new QComboBox(true, render1);
	RenderParams->insertItem(prefs.getRenderProgramParam1());
	RenderParams->insertItem(prefs.getRenderProgramParam2());
	RenderParams->insertItem(prefs.getRenderProgramParam3());
	RenderParams->setCurrentItem(prefs.getActiveRenderProgramParam() );
	RenderParams->setGeometry(5,40,390,25);	

// Renderer fr Preview im Editor

	RenderPreviewProgram = new GetFileWidget(render2,i18n("Program") ,prefs.getRenderPreviewProgram(),0);
	RenderPreviewProgram->setGeometry(5,10,390,25);

	RenderPreviewParams = new QComboBox(true, render2);
	RenderPreviewParams->insertItem(prefs.getRenderPreviewProgramParam1());
	RenderPreviewParams->insertItem(prefs.getRenderPreviewProgramParam2());
	RenderPreviewParams->insertItem(prefs.getRenderPreviewProgramParam3());
	RenderPreviewParams->setCurrentItem(prefs.getActiveRenderPreviewProgramParam() );	
	RenderPreviewParams->setGeometry(5,40,390,25);

// Renderer fr Texturansicht

	RenderSmallPreviewProgram = new GetFileWidget(render3,i18n("Program:") ,prefs.getRenderSmallPreviewProgram(),0);
	RenderSmallPreviewProgram->setGeometry(5,10,390,25);

	RenderSmallPreviewParams = new QComboBox(true, render3);
	RenderSmallPreviewParams->insertItem(prefs.getRenderSmallPreviewProgramParam1());
	RenderSmallPreviewParams->insertItem(prefs.getRenderSmallPreviewProgramParam2());
	RenderSmallPreviewParams->insertItem(prefs.getRenderSmallPreviewProgramParam3());
	RenderSmallPreviewParams->setCurrentItem(prefs.getActiveRenderSmallPreviewProgramParam() );	

	RenderSmallPreviewParams->setGeometry(5,40,390,25);

	QString		str;

	lscreensize = new QLabel(screenpage);
	lscreensize->setText(i18n("Screensize (mm):"));

	screenwidth = new QLineEdit(screenpage);
	str.setNum(prefs.getScreenWidth());
	screenwidth->setText(str);
	screenheight = new QLineEdit(screenpage);
	str.setNum(prefs.getScreenHeight());
	screenheight->setText(str);

	lresolution = new QLabel(screenpage);
	lresolution->setText(i18n("Screenresolution (pixel):"));

	reswidth = new QLineEdit(screenpage);
	str.setNum(prefs.getResolutionWidth());
	reswidth->setText(str);
	resheight = new QLineEdit(screenpage);
	str.setNum(prefs.getResolutionHeight());
	resheight->setText(str);


	lgridspace_xy = new QLabel(screenpage);
	lgridspace_xy->setText(i18n("Gridspace XY:"));

	gridspace_xy = new QLineEdit(screenpage);
	str.setNum(prefs.getGridSpaceXY());
	gridspace_xy->setText(str);

	lgridspace_xz = new QLabel(screenpage);
	lgridspace_xz->setText(i18n("Gridspace XZ:"));

	gridspace_xz = new QLineEdit(screenpage);
	str.setNum(prefs.getGridSpaceXZ());
	gridspace_xz->setText(str);

	lgridspace_zy = new QLabel(screenpage);
	lgridspace_zy->setText(i18n("Gridspace ZY:"));

	gridspace_zy = new QLineEdit(screenpage);
	str.setNum(prefs.getGridSpaceZY());
	gridspace_zy->setText(str);

	lgridlines_xy = new QLabel(screenpage);
	lgridlines_xy->setText(i18n("Gridlines XY:"));

	gridlines_xy = new QLineEdit(screenpage);
	str.setNum(prefs.getGridLinesXY());
	gridlines_xy->setText(str);

	grid_xy = new QCheckBox(i18n("in perspective View"),screenpage);
	grid_xy->setChecked(prefs.getGridXY());

	lgridlines_xz = new QLabel(screenpage);
	lgridlines_xz->setText(i18n("Gridlines XZ:"));

	gridlines_xz = new QLineEdit(screenpage);
	str.setNum(prefs.getGridLinesXZ());
	gridlines_xz->setText(str);

	grid_xz = new QCheckBox(i18n("in perspective View"),screenpage);
	grid_xz->setChecked(prefs.getGridXZ());

	lgridlines_zy = new QLabel(screenpage);
	lgridlines_zy->setText(i18n("Gridlines ZY:"));

	gridlines_zy = new QLineEdit(screenpage);
	str.setNum(prefs.getGridLinesZY());
	gridlines_zy->setText(str);

	grid_zy = new QCheckBox(i18n("in perspective View"),screenpage);
	grid_zy->setChecked(prefs.getGridZY());


	autosavepicture = new QCheckBox(i18n("automatic save rendered picture"),miscpage);
	autosavepicture->setChecked(prefs.getAutoSavePicture());

	translatepov = new QCheckBox(i18n("translate POVRay-terms too"),miscpage);
	translatepov->setChecked(prefs.getTranslatePOV());

	// PVM-Einstellungen

	clusterListView=new QListBox(clusterpage);
	QToolTip::add(clusterListView,i18n("All Clusterlements wich should be used") );

	for(i = 0;i < prefs.numClusterHosts();i++)
	{
		clusterListView->insertItem(prefs.recentClusterHost(i));
	}

	connect(clusterListView,SIGNAL(selected(const char*)),this,SLOT(clusterSelect(const char*) ) );

	newClusterLine=new QLineEdit(clusterpage);
	QToolTip::add(newClusterLine,i18n("Hostname/IP-Adress of a new Clusterelement") );	

	speedClusterLine=new QLineEdit(clusterpage);
	QToolTip::add(speedClusterLine,i18n("Relative speed of the host") );	

	addCluster=new QPushButton(i18n("Add / Change"),clusterpage);
	QToolTip::add(addCluster,i18n("add a Clusterelement") );
	connect(addCluster,SIGNAL(clicked()),this,SLOT(addClusterPressed()));

	deleteCluster=new QPushButton(i18n("Delete"),clusterpage);
	QToolTip::add(deleteCluster,i18n("Delete Clusterelement") );
	connect(deleteCluster,SIGNAL(clicked()),this,SLOT(deleteClusterPressed()));

	showClusterStat=new QCheckBox(i18n("Show statistics"),clusterpage);
	showClusterStat->setChecked(prefs.getShowClusterStatistics());
	QToolTip::add(showClusterStat,i18n("Show statistics during renderprocess") );

	resize(450,400);


	if(!hasCancelButton())
		setCancelButton(i18n("Cancel") );
	if(!hasOkButton())
		setOkButton(i18n("OK") );

	connect(this,SIGNAL(applyButtonPressed()),this,SLOT(Apply()));
	connect(this,SIGNAL(cancelButtonPressed()),this,SLOT(Cancel()));


	
	paintEvent(0);
}

void PreferencesDialog::clusterSelect(const char*c)
{
char *a,*b;

	a=strtok( (char*)c,"=");
	b=strtok(NULL,"=");
	//if (b==NULL) speedClusterLine->setText("50");
	//speedClusterLine->setText(b);
	newClusterLine->setText(a);

}

void PreferencesDialog::deleteClusterPressed()
{
	if (clusterListView->currentItem()==-1) return;
	clusterListView->removeItem(clusterListView->currentItem());
}

void PreferencesDialog::addClusterPressed()
{
char *txt=(char *)malloc(1024);
int i;
	if (!(strcmp(newClusterLine->text(),""))) return;

	i=0;
	for (i=0;i<(int)clusterListView->count();i++) {
		if (!(strcmp(strtok( (char*)clusterListView->text(i),"="),newClusterLine->text()))) {
			clusterListView->removeItem(i);
		}
	}
	//if (!(strcmp(speedClusterLine->text(),""))) sprintf(txt,"%s=50",newClusterLine->text() );
	//else sprintf(txt,"%s=%s",newClusterLine->text(),speedClusterLine->text() );
	sprintf(txt,"%s",newClusterLine->text());	
	clusterListView->insertItem(txt);
	free(txt);
}

PreferencesDialog::~PreferencesDialog()
{
	delete autosavepicture;
}

void PreferencesDialog::Apply()
{
int i;

	prefs.setTexturePath(TexturePathWidget->getFilename());
	prefs.setTempPath(TempPathWidget->getFilename());
	prefs.setImagePath(ImagePathWidget->getFilename());
	prefs.setImageMapPath(imageMapPathWidget->getFilename());
	prefs.setBumpMapPath(BumpMapPathWidget->getFilename());
	prefs.setAnimationPath(AnimationPathWidget->getFilename());
	prefs.setDataPath(DataPathWidget->getFilename());
	prefs.setFontPath(fontPathWidget->getFilename());
	prefs.setHeightfieldPath(heightfieldPathWidget->getFilename());

	prefs.setGridColor(GridColor->color());
	prefs.setXAxisColor(XAxisColor->color());
	prefs.setYAxisColor(YAxisColor->color());
	prefs.setZAxisColor(ZAxisColor->color());
	prefs.setBackgroundColor(BackgroundColor->color());
	prefs.setLinesColor(LineColor->color());
	prefs.setSelectedLinesColor(SelectedLineColor->color());
	prefs.setBlobColor(BlobColor->color());
	prefs.setDrawAxes(DrawAxisCheckBox->isChecked());	
	prefs.setLetterXColor(LetterXColor->color() );
	prefs.setLetterYColor(LetterYColor->color() );
	prefs.setLetterZColor(LetterZColor->color() );

	
	prefs.setRenderProgram(RenderProgram->getFilename());
 	prefs.setRenderProgramParams(RenderParams->text(0), RenderParams->text(1), RenderParams->text(2), RenderParams->currentItem() );


	prefs.setRenderPreviewProgram(RenderPreviewProgram->getFilename());
	prefs.setRenderPreviewProgramParams(RenderPreviewParams->text(0), RenderPreviewParams->text(1), RenderPreviewParams->text(2), RenderPreviewParams->currentItem() );

	prefs.setRenderSmallPreviewProgram(RenderSmallPreviewProgram->getFilename());
	prefs.setRenderSmallPreviewProgramParams(RenderSmallPreviewParams->text(0), RenderSmallPreviewParams->text(1), RenderSmallPreviewParams->text(2), RenderSmallPreviewParams->currentItem() );

	QString	str;
	int	w,h;

	str = screenwidth->text();
	w = str.toInt();
	str = screenheight->text();
	h = str.toInt();
	prefs.setScreenSize(w,h);

	str = reswidth->text();
	w = str.toInt();
	str = resheight->text();
	h = str.toInt();
	prefs.setResolution(w,h);

	double	d;
	
	str = gridlines_xy->text();
	i = str.toInt();
	prefs.setGridLinesXY(i);
	prefs.setGridXY(grid_xy->isChecked());
 	str = gridspace_xy->text();
	d = str.toDouble();
	prefs.setGridSpaceXY(d);

	str = gridlines_xz->text();
	i = str.toInt();
	prefs.setGridLinesXZ(i);
	prefs.setGridXZ(grid_xz->isChecked());
 	str = gridspace_xz->text();
	d = str.toDouble();
	prefs.setGridSpaceXZ(d);

	str = gridlines_zy->text();
	i = str.toInt();
	prefs.setGridLinesZY(i);
	prefs.setGridZY(grid_zy->isChecked());
 	str = gridspace_zy->text();
	d = str.toDouble();
	prefs.setGridSpaceZY(d);

	
	prefs.setAutoSavePicture(autosavepicture->isChecked());
	prefs.setTranslatePOV(translatepov->isChecked());

	prefs.setShowClusterStatistics(showClusterStat->isChecked() );

	prefs.deleteClusterHostList();
	for (i=0;i<(int)clusterListView->count();i++)
	{
		prefs.setClusterHost( clusterListView->text(i));
	}

		
	prefs.save();

	emit update();
}

void PreferencesDialog::Cancel()
{
}

void	PreferencesDialog::paintEvent(QPaintEvent *pe)
{
	int	x,y,w,h,w1,w2,x2,x3,x4;
	
	pathpage->setGeometry(10,10,width() - 20,height() - 20);
	renderpage->setGeometry(10,10,width() - 20,height() - 20);
	editorpage->setGeometry(10,10,width() - 20,height() - 20);
	screenpage->setGeometry(10,10,width() - 20,height() - 20);
	miscpage->setGeometry(10,10,width() - 20,height() - 20);
	clusterpage->setGeometry(10,10,width() - 20,height() - 20);

	
	x = 5;
	y = 5;
	w = renderpage->width() - 20;
	h = (renderpage->height() - 20 - 30 - 30) / 3;

	render1->setGeometry(x,y,w,h);
	y += h + 5;
	render2->setGeometry(x,y,w,h);
	y += h + 5;
	render3->setGeometry(x,y,w,h);

	
//Renderer fr richtige Berechnung

	x = 10;
	y = 20;
	w = render1->width() - 20;
	h = 25;
	
	RenderProgram->setGeometry(x,y,w,h);
	y += 25 + 5;
	RenderParams->setGeometry(x,y,w,h);	

// Renderer fr Preview im Editor

	x = 10;
	y = 20;
	w = render2->width() - 20;
	h = 25;
	
	RenderPreviewProgram->setGeometry(x,y,w,h);
	y += 25 + 5;
	RenderPreviewParams->setGeometry(x,y,w,h);

// Renderer fr Texturansicht

	x = 10;
	y = 20;
	w = render3->width() - 20;
	h = 25;
	
	RenderSmallPreviewProgram->setGeometry(x,y,w,h);
	y += 25 + 5;
   	RenderSmallPreviewParams->setGeometry(x,y,w,h);

   	
/***********************************************************************/
   	

	x = 10;
	y = 5;
	w = MAX(DataPathWidget->getLabelWidthHint(),0);
	w = MAX(TexturePathWidget->getLabelWidthHint(),w);
	w = MAX(imageMapPathWidget->getLabelWidthHint(),w);
	w = MAX(BumpMapPathWidget->getLabelWidthHint(),w);
	w = MAX(fontPathWidget->getLabelWidthHint(),w);
	w = MAX(heightfieldPathWidget->getLabelWidthHint(),w);
	w = MAX(ImagePathWidget->getLabelWidthHint(),w);
	w = MAX(AnimationPathWidget->getLabelWidthHint(),w);
	w = MAX(TempPathWidget->getLabelWidthHint(),w);
	w2 = pathpage->width() - 20;
	h = 25;
	DataPathWidget->setLabelWidth(w);
	DataPathWidget->setGeometry(x,y,w2,h);
	y += h + 5;
	TexturePathWidget->setLabelWidth(w);
	TexturePathWidget->setGeometry(x,y,w2,h);
	y += h + 5;
	imageMapPathWidget->setLabelWidth(w);
	imageMapPathWidget->setGeometry(x,y,w2,h);
	y += h + 5;
	BumpMapPathWidget->setLabelWidth(w);
	BumpMapPathWidget->setGeometry(x,y,w2,h);
	y += h + 5;
	fontPathWidget->setLabelWidth(w);
	fontPathWidget->setGeometry(x,y,w2,h);
	y += h + 5;
	heightfieldPathWidget->setLabelWidth(w);
	heightfieldPathWidget->setGeometry(x,y,w2,h);
	y += h + 5;
	ImagePathWidget->setLabelWidth(w);
	ImagePathWidget->setGeometry(x,y,w2,h);
	y += h + 5;
	AnimationPathWidget->setLabelWidth(w);
	AnimationPathWidget->setGeometry(x,y,w2,h);
	y += h + 5;
	TempPathWidget->setLabelWidth(w);
	TempPathWidget->setGeometry(x,y,w2,h);

/***********************************************************************/
	
	x = 10;
	y = 5;
	w = 120;
	w2 = 35;
	h = 25;
	x2 = x + w + 5;
	x3 = x2 + w2 + 15;
	x4 = x3 + w + 5;

	GridColorLabel->setGeometry(x,y,w,h);
	GridColor->setGeometry(x2,y,w2,h);

	y += h + 5;
	XAxisColorLabel->setGeometry(x,y,w,h);
	XAxisColor->setGeometry(x2,y,w2,h);

	LetterXColorLabel->setGeometry(x3,y,w,h);
	LetterXColor->setGeometry(x4,y,w2,h);

	y += h + 5;
	YAxisColorLabel->setGeometry(x,y,w,h);
	YAxisColor->setGeometry(x2,y,w2,h);

	LetterYColorLabel->setGeometry(x3,y,w,h);
	LetterYColor->setGeometry(x4,y,w2,h);

	y += h + 5;
	ZAxisColorLabel->setGeometry(x,y,w,h);
	ZAxisColor->setGeometry(x2,y,w2,h);

	LetterZColorLabel->setGeometry(x3,y,w,h);
	LetterZColor->setGeometry(x4,y,w2,h);

	y += h + 5;
	BackgroundColorLabel->setGeometry(x,y,w,h);
	BackgroundColor->setGeometry(x2,y,w2,h);

	y += h + 5;
	LineColorLabel->setGeometry(x,y,w,h);
	LineColor->setGeometry(x2,y,w2,h);

	y += h + 5;
	SelectedLineColorLabel->setGeometry(x,y,w,h);
	SelectedLineColor->setGeometry(x2,y,w2,h);

	y += h + 5;
	BlobColorLabel->setGeometry(x,y,w,h);
	BlobColor->setGeometry(x2,y,w2,h);

	y += h + 5;
	BoxColorLabel->setGeometry(x,y,w,h);
	BoxColor->setGeometry(x2,y,w2,h);

	y += h + 5;
	DrawAxisCheckBox->setGeometry(x,y,w,h);

/***********************************************************************/
   	
 	x = 10;
	y = 5;
	
	w1 = lscreensize->sizeHint().width();
	w1 = MAX(w1,lresolution->sizeHint().width());
	w1 = MAX(w1,lgridlines_xy->sizeHint().width());
	w1 = MAX(w1,lgridlines_xz->sizeHint().width());
	w1 = MAX(w1,lgridlines_zy->sizeHint().width());
	w1 = MAX(w1,lgridspace_xy->sizeHint().width());
	w1 = MAX(w1,lgridspace_xz->sizeHint().width());
	w1 = MAX(w1,lgridspace_zy->sizeHint().width());
	
	w2 = 60;
	w = w1;
	h = 25;
  	
	w1 = grid_xy->sizeHint().width();
	w1 = MAX(w1,grid_xz->sizeHint().width());
	w1 = MAX(w1,grid_zy->sizeHint().width());
	
	lscreensize->setGeometry(x,y,w,h);
	x += w + 5;
	screenwidth->setGeometry(x,y,w2,h);
	x += w2 + 5;
	screenheight->setGeometry(x,y,w2,h);

	x = 10;
	y += h + 5;
	lresolution->setGeometry(x,y,w,h);
	x += w + 5;
	reswidth->setGeometry(x,y,w2,h);
	x += w2 + 5;
	resheight->setGeometry(x,y,w2,h);

	x = 10;
	y += h + 5;
	lgridlines_xy->setGeometry(x,y,w,h);
	x += w + 5;
	gridlines_xy->setGeometry(x,y,w2,h);
	x += w2 + 5;
	grid_xy->setGeometry(x,y,w1,h);

	x = 10;
	y += h + 5;
	lgridlines_xz->setGeometry(x,y,w,h);
	x += w + 5;
	gridlines_xz->setGeometry(x,y,w2,h);
	x += w2 + 5;
	grid_xz->setGeometry(x,y,w1,h);

	x = 10;
	y += h + 5;
	lgridlines_zy->setGeometry(x,y,w,h);
	x += w + 5;
	gridlines_zy->setGeometry(x,y,w2,h);
	x += w2 + 5;
	grid_zy->setGeometry(x,y,w1,h);

	x = 10;
	y += h + 5;
	lgridspace_xy->setGeometry(x,y,w,h);
	x += w + 5;
	gridspace_xy->setGeometry(x,y,w2,h);

	x = 10;
	y += h + 5;
	lgridspace_xz->setGeometry(x,y,w,h);
	x += w + 5;
	gridspace_xz->setGeometry(x,y,w2,h);

	x = 10;
	y += h + 5;
	lgridspace_zy->setGeometry(x,y,w,h);
	x += w + 5;
	gridspace_zy->setGeometry(x,y,w2,h);

/***********************************************************************/
   	
 	x = 10;
	y = 5;
	w = miscpage->width() - 20;
	h = 25;
	autosavepicture->setGeometry(x,y,w,h);
	
 	x = 10;
	y += h + 5;
	w = miscpage->width() - 20;
	h = 25;
	translatepov->setGeometry(x,y,w,h);
	
/***********************************************************************/

	w=clusterpage->width();
	h=clusterpage->height();
	x=0;
	y=0;
	x2=0;

	clusterListView->setGeometry(10,5,w-20,h/2);
	y+=h/2+10;

	h=newClusterLine->sizeHint().height();

	newClusterLine->setGeometry(10,y,width()/10*8-5,h);
	speedClusterLine->setGeometry(10+width()/10*8,y,width()/10*2,h);
	
	y+=h+5;

	x=addCluster->sizeHint().width();
	h=addCluster->sizeHint().height();
	x2=deleteCluster->sizeHint().width();

	addCluster->setGeometry(10,y,x,h);
	deleteCluster->setGeometry(15+x,y,x2,h);

	y+=h+5;

	w=showClusterStat->sizeHint().width();
	h=showClusterStat->sizeHint().height();
	
	showClusterStat->setGeometry(10,y,w,h);

	if(pe) QTabDialog::paintEvent(pe);
}

