/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** df3wizard.cpp
*/
#include "df3wizard.moc"

#include <chunk.h>
#include <kapp.h>


df3Wizard::df3Wizard(QWidget *parent,char *name) :
	QDialog(parent,name,true)
{
int y=0,x=0;
	
	picA=new QImage(100,100,8,256);
	picB=new QImage(100,100,8,256);

	sizeWidget=new VectorWidget(this,"");
	sizeWidget->setVector(Vector3(16,16,16) );

	ok=new QPushButton(this);
	ok->setText(i18n("Convert"));
	ok->setAutoDefault(true);

	y+=ok->sizeHint().height()+5;
	x=ok->sizeHint().width()+5;	


	cancel=new QPushButton(this);
	cancel->setText(i18n("Cancel"));

	x=MAX(cancel->sizeHint().width()+5,x);	

	previewA=new QFrame(this,"Depth-Preview");
	previewA->setFrameStyle(QFrame::Box | QFrame::Sunken);

	painterA=new QPainter(previewA);

	previewB=new QFrame(this,"Density-Preview");
	previewB->setFrameStyle(QFrame::Box | QFrame::Sunken);
	painterB=new QPainter(previewB);

	y+=105;
	x=MAX(ok->sizeHint().width()+5,105);	

	source1=new GetFileWidget(this,i18n("Depth"),"/",1);
	source2=new GetFileWidget(this,i18n("Density"),"/",1);

	dest=new GetFileWidget(this,i18n("Destination"),"/",0);

	y+=3*(dest->sizeHint().height()+5);
	x=MAX(dest->sizeHint().width()+5,x);	

	invert=new QPushButton(this);
	invert->setText(i18n("Invert"));

	y+=invert->sizeHint().height();

	connect(ok,SIGNAL(clicked()),this,SLOT(okayPressed() ));
	connect(cancel,SIGNAL(clicked()),this,SLOT(cancelPressed() ));
	connect(invert,SIGNAL(clicked()),this,SLOT(invertPressed() ));

	connect(source1,SIGNAL(changed()),this,SLOT(newSource1()) );
	connect(source2,SIGNAL(changed()),this,SLOT(newSource2()) );

	setCaption(i18n("DF3 Wizard"));
	setMinimumSize(x,y);
	setMaximumSize(x,y);
	resize(x,y);
}

void df3Wizard::newSource1()
{
QImage	qi1,qi2;
int r,g,b,i,d;
        	
	qi1.load( (const char *) source1->getFilename());

	qi2=qi1.convertDepth(8);

	for (i=0;i<qi2.numColors();i++) {

		r=qRed(qi2.color(i));
		g=qGreen(qi2.color(i));
		b=qBlue(qi2.color(i));

		d=(int)((r+g+b)/3);	
		qi2.setColor(i,qRgb(d,d,d));

	}

	if (picA) delete picA;
	picA=new QImage(qi2);

	paintEvent(NULL);	
}

void df3Wizard::newSource2()
{
QImage	qi1,qi2;
int r,g,b,i,d;
        	
	qi1.load( (const char *) source2->getFilename());

	qi2=qi1.convertDepth(8);

	for (i=0;i<qi2.numColors();i++) {

		r=qRed(qi2.color(i));
		g=qGreen(qi2.color(i));
		b=qBlue(qi2.color(i));

		d=(int)((r+g+b)/3);	
		qi2.setColor(i,qRgb(d,d,d));

	}

	if (picB) delete picB;
	picB=new QImage(qi2);

	paintEvent(NULL);	
}

void df3Wizard::exec()
{
	QDialog::show();
}

df3Wizard::~df3Wizard()
{
	if (painterA) delete painterA;
	if (painterB) delete painterB;
	if (picA) delete picA;
	if (picB) delete picB;
}

void df3Wizard::okayPressed()
{
FILE *fp;
unsigned char *dataA,*dataB;
int x,y,z;
Vector3 size=sizeWidget->getVector();
int wx=(int)size[0],wy=(int)size[1],wz=(int)size[2];

	dataA=(unsigned char *)malloc(picA->width());
	dataB=(unsigned char*)malloc(picB->width());

	fp=fopen(dest->getFilename(),"w");
	if (fp) {
		double v;
		fputc((unsigned char)(wx>>8),fp );
		fputc((unsigned char)(wx&255),fp );
		fputc((unsigned char)(wy>>8),fp );
		fputc((unsigned char)(wy&255),fp );
		fputc((unsigned char)(wz>>8),fp );
		fputc((unsigned char)(wz&255),fp );
                for (x=0;x<wx;x++) {
			dataA=picA->scanLine(((double)x)/wx*picA->height() );
			dataB=picB->scanLine(((double)x)/wx*picB->height() );
                	for (y=0;y<wy;y++) {
		                for (z=0;z<wz;z++) {
					v=dataB[y]*(1-fabs(dataA[y]-(((double)z)/wz)) );
					fputc((unsigned char)(255*v),fp );
				}
			}
		}
		fclose(fp);
		QDialog::done(1);
	}
}

void df3Wizard::cancelPressed()
{
	QDialog::done(-1);
}


void df3Wizard::invertPressed()
{
int i,d;
	for (i=0;i<picB->numColors();i++) {

		d=qRed(picB->color(i));
		d=255-d;
		picB->setColor(i,qRgb(d,d,d));

	}
	
	paintEvent(NULL);
}

void df3Wizard::paintEvent(QPaintEvent *qp)
{
int y=0;
int wl,w,h,wm,w2;
QImage qi;

	if (picA) {

		int z=MAX(picA->width(),picA->height());
		double s=(double)(70.0/z);

		qi=picA->smoothScale((int)(s*picA->width()),(int)(s*picA->height()));
		painterA->begin(previewA);
		painterA->drawImage(0,0,qi);
		painterA->end();
	}

	if (picB) {

		int z=MAX(picB->width(),picB->height());
		double s=(double)(70.0/z);

		qi=picB->smoothScale((int)(s*picB->width()),(int)(s*picB->height()));
		painterB->begin(previewB);
		painterB->drawImage(0,0,qi);
		painterB->end();
	}

	previewA->setGeometry(10,10,70,70);
	previewB->setGeometry(90,10,70,70);


	w=sizeWidget->sizeHint().width();
	h=sizeWidget->sizeHint().height();
	
	sizeWidget->setGeometry(170,10,w,h);


	wm=170;
	y=MAX(90,h);

	w=invert->sizeHint().width();
	h=invert->sizeHint().height();

	invert->setGeometry(width()/2-w/2,y,w,h);	

	y+=h+5;

	wl=MAX(source1->getLabelWidthHint(),dest->getLabelWidthHint() );
	wl=MAX(source2->getLabelWidthHint(),wl );

	source1->setLabelWidth(wl);
	source2->setLabelWidth(wl);
	dest->setLabelWidth(wl);

	w=source1->sizeHint().width();
	h=source1->sizeHint().height();
	
	source1->setGeometry(10,y,w,h);
	y+=h+5;

	source2->setGeometry(10,y,w,h);
	y+=h+5;

	w=dest->sizeHint().width();

	dest->setGeometry(10,y,w,h);
	y+=h+5;

	wm=MAX(w,wm);

	h=cancel->sizeHint().height();
	w=cancel->sizeHint().width();
	w2=ok->sizeHint().width();
	
	ok->setGeometry(width()-w2-w-10,y,w2,h);
	cancel->setGeometry(width()-w-5,y,w,h);

	if (qp) QDialog::paintEvent(qp);
}