/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** warp_bak.cpp
*/
#include "warp.h"

  /* XPM */
const char*warpPic[]={
"20 20 2 1",
"# c #000000",
". c None",
"....................",
"...##....##....##...",
"....##....##....##..",
".....##....##....##.",
"......##....##....#.",
".#.....##....##.....",
".##.....##....##....",
"..##.....##....##...",
"...##.....##....##..",
"....##.....##....##.",
".....##.....##....#.",
"......##.....##.....",
".......##.....##....",
"........##.....##...",
".........##.....##..",
"..........##.....##.",
"...........##.....#.",
"............##......",
".............##.....",
"...................."};

warp::warp(textureBase *p):textureBase(WARP,p)
{
	setName("Warp");
	setInfo("Warp");
	setSubItems(true);

	addAddableItem(REPEATWARP,true);
	addAddableItem(BLACKHOLEWARP,true);
	addAddableItem(TURBULENCEMODIFIER,true);
}

const char **warp::getXPM()
{
	return warpPic;
}

warp::~warp()
{
}

int	warp::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	#ifdef DEBUG
		printf("Loading Warp\n");
	#endif

	if(!m) return -1;
	setMedia(m);	
	

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if(strncmp(chunk,"WRPR",4) == 0) {
			repeatWarp *rw=new repeatWarp(this);
			rw->load(m,len);
			addElement(rw,NULL);		
			read=true;
		}
		if(strncmp(chunk,"WRPB",4) == 0) {
			blackHoleWarp *rw=new blackHoleWarp(this);
			rw->load(m,len);
			addElement(rw,NULL);		
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *rw=new Turbulence(this);
			rw->load(m,len);
			addElement(rw,NULL);		
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...
	#ifdef DEBUG
		printf("warp loaded\n");
	#endif
	//updateInfo();
	return 0;
}



int warp::save(media *m)
{
int i;
	if(!m)	return -1;
	#ifdef DEBUG
		printf("saving warp\n");
	#endif

	setMedia(m);

	writeChunk("WARP");


	textureBase::save(m);
	
	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}

	writeChunkLen();

	#ifdef DEBUG
		printf("warp saved\n");
	#endif
	return 0;
}

int warp::exportPOV(FILE *fp,int tab,int tabsize, int anim,bool dummy)
{
int i;
	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting warp (POV)\n");
	#endif


	printTab(fp,tab+tabsize);
	fprintf(fp,"warp {  //%s \n",getName() );	

	for (i=0;i<elements.length();i++) {
		if (elements[i]->active()==true) {
		elements[i]->exportPOV(fp,tab+2*tabsize,tabsize,anim,dummy);
		}
	}

	textureBase::exportPOV(fp,tab+tabsize,tabsize,anim,dummy);

	printTab(fp,tab+tabsize);
	fprintf(fp,"}\n");	

	#ifdef DEBUG
		printf("warp exported (POV) saved\n");
	#endif
	return 0;
}


