/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturemap.cpp
*/

#include "texturemap.h"

texturemap::texturemap(char *n)
{
	_name = strdup(n);
}

texturemap::~texturemap()
{
	if(_name) free(_name);
}

char	*texturemap::name()
{
	return _name;
}

texture	*texturemap::findTexture(char *n)
{
	int	i;
	texture	*t;

	for(i = 0;i < texturelist.length();i++)
	{
		if(strcmp(texturelist[i]->getName(),n) == 0)
			return texturelist[i];
	}
	for(i = 0;i < texturemaplist.length();i++)
	{
		t = texturemaplist[i]->findTexture(n);
		if(t != 0)
			return t;
	}

	return 0;
}

char	*texturemap::texturePath(char *n)
{
	int	i;
	char	*cp,*str;

	for(i = 0;i < texturelist.length();i++)
	{
		if(strcmp(texturelist[i]->getName(),n) == 0)
			return strdup(texturelist[i]->getName());
	}
	for(i = 0;i < texturemaplist.length();i++)
	{
		cp = texturemaplist[i]->texturePath(n);
		if(cp != 0)
		{
			str = (char*)malloc(strlen(cp) + strlen(_name) + 2);
			strcpy(str,_name);
			strcat(str,"/");
			strcat(str,cp);

			free(cp);

			return str;
		}
	}

	return 0;
}


void	texturemap::addTexture(texture *t)
{
	texturelist.append(t);
}

void	texturemap::addTexturemap(texturemap *tm)
{
	texturemaplist.append(tm);
}

void	texturemap::removeTexture(texture *t)
{
	if(texturelist.find(t))
		texturelist.deleteCurrent();
}

void	texturemap::removeTexturemap(texturemap *tm)
{
	if(texturemaplist.find(tm))
		texturemaplist.deleteCurrent();
}

int	texturemap::getNumTextures()
{
	return texturelist.length();
}

texture	*texturemap::getTexture(int n)
{
	return texturelist[n];
}

texture	*texturemap::getFirstTexture()
{
	return texturelist.getFirst();
}

texture	*texturemap::getNextTexture()
{
	return ++texturelist;
}

int	texturemap::getNumTextureMaps()
{
	return texturemaplist.length();
}

texturemap	*texturemap::getTextureMap(int n)
{
	return texturemaplist[n];
}

texturemap	*texturemap::getFirstTexturemap()
{
	return texturemaplist.getFirst();
}

texturemap	*texturemap::getNextTexturemap()
{
	return ++texturemaplist;
}

int		texturemap::save(media *m)
{
	int	n;

	if(!m) return -1;

	setMedia(m);

	writeChunk("TXTM");

	writeName(_name);

	for(n = 0;n < texturelist.length();n++)
	{
		texturelist[n]->save(m);
	}
	for(n = 0;n < texturemaplist.length();n++)
	{
		texturemaplist[n]->save(m);
	}

	writeChunkLen();

	return 0;
}

int	texturemap::load(media *m,int l)
{
	int	pos,len;
	char	chunk[4];

	if(!m) return -1;

	setMedia(m);

	pos = m->tell();	

	_name = readName();

	while(l > m->tell() - pos)
	{
		m->read(chunk,4);
		m->read(&len,sizeof(int));

		if(strncmp(chunk,"TXTM",4) == 0)
		{
			texturemap	*tm;

			tm = new texturemap("");
			tm->load(m,len);
			texturemaplist += tm;
		}
		else if(strncmp(chunk,"TXTR",4) == 0)
		{
			texture		*t;

			t = new texture(NULL);
			t->load(m,len);
			texturelist += t;
		}
		else
			m->seek(len,SEEK_CUR);
	}

	return 0;
}




