/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturebook.cpp
*/
#include "texturebook.h"

#include <misc.h>

#include <stdio.h>


TextureBook::TextureBook(textureBase *p):textureBase(TEXTUREBOOK,p)
{
	setName("Texturebook");
	setInfo("Texturebook");
	setSubItems(true);

}

TextureBook::~TextureBook()
{
}


texture *TextureBook::findTexturePath(const char *n)
{
int i;
	char		buffer[1024];
	char		*cp;

	if(n == 0) return 0;

	strcpy(buffer,n);
	cp=strrchr(buffer,'/');
	if (cp) {
		*cp=0;
		cp++;
	}
	if (!cp) {
		for (i=0;i<elements.length();i++) {		
			if (elements[i]->getType()==TEXTURE) {
				if (!(strcmp(elements[i]->getName(),buffer))) return (texture *)elements[i];
			}
		}
		return 0;	
	}
#ifdef DEBUG
	printf("Finding TexturePath in Book :%s",n);
#endif
	for (i=0;i<elements.length();i++) {
		if (elements[i]->getType()==TEXTUREBOOK) {
			TextureBook *tb=(TextureBook*)elements[i];
			if (!(strcmp(tb->getName(),cp))) {			
	        	        texture *te=(texture *)tb->findTexturePath(buffer);
				if (te!=NULL) return te;
			}
		}
	}
	return NULL;
}

bool TextureBook::exists(char *n)
{
	if (findTexture(n)!=NULL) return true;
	return false;
}


textureBase *TextureBook::findTexture(const char *n)
{
int i;
	for (i=0;i<elements.length();i++) {
		if (elements[i]->getType()==TEXTUREBOOK) return ((TextureBook*)elements[i])->findTexture(n);
		else if (!(strcmp(n,elements[i]->getName()))) return elements[i];
	}
	return NULL;
}

textureBase *TextureBook::findTextureStruct(texture *t)
{
int i;
	for (i=0;i<elements.length();i++) {
#ifdef DEBUG
	printf(" *** Searching:%s\n",elements[i]->getName() );
#endif
		if (elements[i]->getType()==TEXTUREBOOK) return ((TextureBook*)elements[i])->findTextureStruct(t);
		else if (t->isEqual(elements[i])==true) return elements[i];
	}

	return NULL;		
}

bool TextureBook::canAdd(textureBase *tb)
{
int t;
	if (!tb) return false;
	t=tb->getType();
	if (
		(t==TEXTUREBOOK)||
		(t==TEXTURE)||
		(t==PIGMENT)||
		(t==NORMAL)||
		(t==FINISH)||
		(t==INTERIOR)||
		(t==TRANSFORMATIONS)||
		(t==COLOR)||
		(t==IMAGEMAP)||
		(t==COLORMAP)||
		(t==COLORLIST)||
		(t==BUMPMAP)||
		(t==DENSITY)
		
	) return true;
	return false;
}

void TextureBook::addElement(textureBase* what,textureBase* where)
{

#ifdef DEBUG
	printf("Adding TextureBook Element -Element (l=%d)\n",elements.length());
#endif

	if (!what) return;
	what->setParent(this);
	setActive(true,NULL);

	switch (what->getType()) {
		case TEXTURE:
		case TEXTUREBOOK:
			elements.append(what);
		break;
		default:
		{
			texture *t=new texture(this);
			addElement(t,NULL);
			t->add(what);
		}			
		break;
	}
	return;
}

void TextureBook::add(textureBase *t)
{
	if (canAdd(t)==false) return;
 	addElement(t,NULL);
}

int	TextureBook::load(media *m,int l)
{

	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();
	texture	*t;
	TextureBook *tb;

	if(!m)
		return -1;

	#ifdef DEBUG
		printf("loading TextureBook...\n");
	#endif
	setMedia(m);


	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"TXTR",4) == 0) {
			addElement((t = new texture(this)),NULL);
			t->load(m,len);
			read=true;
		}
		if(strncmp(chunk,"TXTB",4) == 0) {
			addElement((tb = new TextureBook(this)),NULL);
			tb->load(m,len);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}

	if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...
	#ifdef DEBUG
		printf("TextureBook loaded\n");
	#endif

	return 0;
}

int	TextureBook::save(media *m)
{

int i;
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving TextureBook \n");
	#endif
	setMedia(m);

	writeChunk("TXTB");
	textureBase::save(m);

	for (i=0;i<elements.length();i++) elements[i]->save(m);

	writeChunkLen();

	#ifdef DEBUG
		printf("TextureBook saved\n");
	#endif

	return 0;
}

int	TextureBook::exportPOV(FILE *fp,int tab,int tabsize, int a,bool dummy)
{
int i;
	for (i=0;i<elements.length();i++) {
		elements[i]->exportPOV(fp,tab,tabsize,a,true);
	}	
	return 0;
}