/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** surfacemap.cpp
*/
#include "surfacemap.h"

#include <misc.h>



surfaceMap::surfaceMap(textureBase *p):textureBase(SURFACEMAP,p)
{
	setName("Surfacemap");
	setInfo("Surfacemap");
	setSubItems(true);

	addAddableItem(SURFACE,false);
	addAddableItem(SURFACEENTRY,true);
	addAddableItem(SURFACEMAP,false);
	addAddableItem(SURFACELIST,false);
	addAddableItem(TURBULENCEMODIFIER,true);
	addAddableItem(TRANSFORMATIONS,true);
	addAddableItem(PATTERNMODIFIER,false);
}

bool surfaceMap::isEqual(textureBase *tb)
{
#ifdef DEBUG
	printf("Comparing Surfacemaps..\n");
#endif

	if (!tb) return false;
	if (textureBase::isEqual(tb)==false) return false;

#ifdef DEBUG
	printf("Compared Surfacemaps..found it !\n");
#endif
	return true;
}

void surfaceMap::add(textureBase *tb)
{
	if (!tb) return;
	addElement(tb,NULL);
}


void surfaceMap::setActive(bool a, textureBase *tb)
{
	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}
	tb->setActive(a,NULL);
}

void surfaceMap::addElement(textureBase* what,textureBase *where)
{
int t;


#ifdef DEBUG
	printf("Adding Surfacemap-Element (length=%d)\n",elements.length());
#endif

      	if (what==NULL) return;
	if (canAdd(what)==false) return;
	what->setParent(this);
	what->setActive(true,NULL);
	t=what->getType();
	switch (t) {
		case SURFACE:
		{
			surfaceEntry *ce=new surfaceEntry(this);
			ce->add(what);
			elements.append(ce);
		}
		break;
		case SURFACELIST:
		{
		textureBase *tb=what->getFirstElement();
			while(tb!=NULL) {
				surfaceEntry *ce=new surfaceEntry(this);
				ce->add( (surfaceEntry *)tb);
				elements.append(ce);
				tb=what->getNextElement();					
			}
		}
		break;
		default:
			textureBase::addElement(what,where);
		break;
	
	}
	sortSurfaceMap();
        updateInfo();
}


void surfaceMap::updateInfo()
{
	char *buffer=(char *)malloc(512);
	
	sprintf(buffer,"Surfacemap (%d Elements)",elements.length());
	setInfo(buffer);
	free(buffer);
}

patternmodifier *surfaceMap::getMapModifier()
{
	return &modifier;
}
surfaceMap::~surfaceMap()
{
}

void surfaceMap::clearSurfaceMap()
{
	textureBase::clearElements();
	updateInfo();
}

void surfaceMap::sortSurfaceMap()
{
int a,i,j;
surfaceEntry *ce;

#ifdef DEBUG
	printf("sorting SurfaceMap\n");
#endif
	a=elements.length();
	for (i=1;i<a;i++) {
		for (j=0;j<i;j++) {
			if ( ((surfaceEntry*)elements[j])->getRange()>((surfaceEntry*)elements[j+1])->getRange() ) {
				ce=(surfaceEntry*)elements[j+1];
				elements[j+1]=elements[j];
				elements[j]=ce;

			}
		}
	}	
#ifdef DEBUG
	printf("SurfaceMap sorted\n");
#endif
	updateInfo();
}
int	surfaceMap::load(media *m,int l)
{
	surfaceEntry *ce;
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;
	setMedia(m);

#ifdef DEBUG
	printf("loading SurfaceMap\n");
#endif


	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"TXTE",4) == 0) {
			ce=new surfaceEntry(this);
			ce->load(m,len);
			elements.append(ce);
			read=true;
		}
		if(strncmp(chunk,"PATM",4) == 0) {
			modifier.load(m,len);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}	
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *trans=new Transformations(this);
			trans->load(m,len);
			addElement(trans,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }
	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

#ifdef DEBUG
	printf("SurfaceMap loaded\n");
#endif
 	sortSurfaceMap();
	updateInfo();
	return 0;
}

int	surfaceMap::save(media *m)
{

int i;
	if(!m) return -1;
#ifdef DEBUG
	printf("saving SurfaceMap\n");
#endif
	setMedia(m);
	
	writeChunk("TXTM");
	textureBase::save(m);

	for (i=0;i<elements.length();i++)  {
		elements[i]->save(m);			
	}
	modifier.save(m);

	writeChunkLen();

	#ifdef DEBUG
		printf("SurfaceMap saved\n");
	#endif*/
	return 0;

}

int surfaceMap::exportPOV(FILE *fp,int tab,int tabsize,int a,bool dummy)
{
int i;
	if(!fp)	return -1;

#ifdef DEBUG
	printf("exporting SurfaceMap (POV)\n");
#endif


	modifier.exportPOV(fp,tab,tabsize,a,false);
	printTab(fp,tab);
	fprintf(fp,"texture_map { //%s\n",getName() );	
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==SURFACEENTRY)) elements[i]->exportPOV(fp,tab+tabsize,tabsize,a,false);			
	}
	printTab(fp,tab);
	fprintf(fp,"}\n" );	

	textureBase::exportPOV(fp,tab,tabsize,a,dummy);	

	#ifdef DEBUG
		printf("SurfaceMap exported (POV)\n");
	#endif
	return 0;
}

