/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** surface.cpp
*/
#include <misc.h>
#include "surface.h"

#include "interior.h"
#include"texture.h"
#include "surfacelist.h"
#include "surfacemap.h"

const char *SurfYellowFolderPic[]={
"15 13 6 1",
"d c #000000",
"b c #ffff00",
". c None",
"# c #999999",
"a c #cccccc",
"c c #ffffff",
"..#####........",
".#ababa#.......",
"#abababa######.",
"#cccccccccccc#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"##############d",
".dddddddddddddd"};

surface::surface(textureBase *p) :
	  textureBase(SURFACE,p)
{
textureBase *tb;
int x;
	setName("Surface");
	setInfo( (char*)"Surface");
	setSubItems(true);
	x=layer=0;

	if (p!=NULL) {
		tb=(textureBase *)(p->getFirstElement());
		while (tb!=NULL) {
			if (tb->getType()==SURFACE) {
				surface *su=(surface *)tb;		
				if (su->getLayer()>=x) x=su->getLayer()+1;
			}
			tb=p->getNextElement();
		}
		layer=x;
	}

	
	addAddableItem(PIGMENT,true);
	addAddableItem(PIGMENTMAP,true);
	addAddableItem(PIGMENTLIST,true);
	addAddableItem(NORMAL,true);
	addAddableItem(NORMALMAP,true);
	addAddableItem(PIGMENTMAP,true);
	addAddableItem(PIGMENTLIST,true);
	addAddableItem(NORMALLIST,true);
	addAddableItem(FINISH,true);
	addAddableItem(TRANSFORMATIONS,true);
	addAddableItem(COLOR,true);
	addAddableItem(IMAGEMAP,true);
	addAddableItem(COLORMAP,true);
	addAddableItem(COLORLIST,true);
	addAddableItem(SURFACEMAP,true);
	addAddableItem(SURFACELIST,true);
	addAddableItem(BUMPMAP,true);
	addAddableItem(SLOPEMAP,true);
}

const char **surface::getXPM()
{
	return SurfYellowFolderPic;
}

int surface::getLayer()
{
	return layer;
}

void surface::setLayer(int l)
{
	layer=l;
}


void	surface::setActive(bool a,textureBase *tb)
{
int i;

	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}

        switch(tb->getType() ) {
		case PIGMENT:
			for (i=0;i<elements.length();i++) {
				if (elements[i]->getType()==PIGMENT) {
					elements[i]->setActive(false,NULL);
				}
			}
			tb->setActive(a);
		break;
		case NORMAL:
			for (i=0;i<elements.length();i++) {
				if (elements[i]->getType()==NORMAL) {
					elements[i]->setActive(false,NULL);
				}
			}
			tb->setActive(a);
		break;
		case FINISH:
			for (i=0;i<elements.length();i++) {
				if (elements[i]->getType()==FINISH) {
					elements[i]->setActive(false,NULL);
				}
			}
			tb->setActive(a);
		break;
		case TRANSFORMATIONS:
			for (i=0;i<elements.length();i++) {
				if (elements[i]->getType()==TRANSFORMATIONS) {
					elements[i]->setActive(false,NULL);
				}
			}
			tb->setActive(a,NULL);
		break;
		default:
		break;
	}
}

void surface::addElement(textureBase* what,textureBase* where)
{
	if (!what) return;
	if (canAdd(what)==false) return;
	what->setParent(this);	
	setActive(true,what);
	switch (what->getType()) {
		case COLOR:
		case COLORLIST:
		case COLORMAP:
		case IMAGEMAP:
		case PIGMENTLIST:
		case PIGMENTMAP:
		{
			pigment *pi=(pigment*)getElementByType(PIGMENT);
			if (!pi) {
				pi=new pigment(this);
				addElement(pi,NULL);
			}
			what->setParent(pi);
			pi->add(what);
		}						
		break;
		case BUMPMAP:
		case SLOPEMAP:
		case NORMALLIST:
		case NORMALMAP:
		{
			normal *no=(normal*)getElementByType(NORMAL);
			if (!no) {
				no=new normal(this);
				addElement(no,NULL);
			}
			what->setParent(no);
			no->add(what);

		}
		break;
		default:
			elements.append(what);
		break;
	}
}

void surface::add(textureBase *tb)
{
	addElement(tb,NULL);
}

bool surface::isEqual(textureBase *tb)
{
#ifdef DEBUG
	printf("Comparing surfaces...\n");
#endif
	if (!tb) return false;
	if (textureBase::isEqual(tb)==false) return false;

#ifdef DEBUG
	printf("Compared surfaces..found it !\n");
#endif
	return true;
}


surface::~surface()
{
}

int	surface::save(media *m)
{
int i;
chunk ch;
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving surface\n");
	#endif
	setMedia(m);

	writeChunk("TXTR");

	textureBase::save(m);

	for (i=0;i<elements.length();i++) elements[i]->save(m);

	ch.setMedia(m);
	ch.writeChunk("DATA");
		m->write(&layer,sizeof(int));
	ch.writeChunkLen();

	writeChunkLen();

	#ifdef DEBUG
		printf("surface saved\n");
	#endif

	return 0;
}

int	surface::load(media *m,int l)
{
	pigment  *pi=NULL;
	normal   *no=NULL;
	finish   *fi=NULL;
	interior *i=NULL; // !!
	surfaceList *sul=NULL;
	surfaceMap *sum=NULL;
	
	Transformations *tr=NULL;

	char	chunk[4];
	int	len,pos = m->tell();
	bool	read=false;

	if(!m)
		return -1;
	#ifdef DEBUG
		printf("loading surface\n");
	#endif

	setMedia(m);
	
	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"PGMT",4) == 0) {
			elements.append ( (pi=new pigment(this)) );
			pi->load(m,len);
			read=true;
		}
		if(strncmp(chunk,"TXTL",4) == 0) {
			elements.append ( (sul=new surfaceList(this)) );
			sul->load(m,len);
			read=true;
		}
		if(strncmp(chunk,"TXTM",4) == 0) {
			elements.append ( (sum=new surfaceMap(this)) );
			sum->load(m,len);
			read=true;
		}
		if(strncmp(chunk,"NRML",4) == 0) {
			elements.append ( (no=new normal(this)) );
			no->load(m,len);
			read=true;
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			elements.append ( (tr=new Transformations(this)) );
			tr->load(m,len);
			read=true;
		}

		if(strncmp(chunk,"FNSH",4) == 0) {
			elements.append ( (fi=new finish(this)) );
			fi->load(m,len);
			read=true;
		}

		if(strncmp(chunk,"INTE",4) == 0) { //Just for VERY old files !!!
			((texture *)parent)->add( (i=new interior(this)) );
			i->load(m,len);
			read=true;
		}

		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if(strncmp(chunk,"DATA",4) == 0) {
			m->read(&layer,sizeof(int));
			read=true;
		}

		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

	#ifdef DEBUG
		printf("surface loaded\n");
	#endif

	return 0;
}

int	surface::exportPOV(FILE *fp,int tab,int tabsize,int anim,bool dummy)
{
	int i;

	#ifdef DEBUG
		printf("exporting surface %d(POV)\n",layer);
	#endif	
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = Texture\n");
	printTab(fp,tab);
        fprintf(fp,"texture { //name=%s Layer=%d\n",name,layer);	

	for (i=0;i<elements.length();i++) if (elements[i]->active()==true) elements[i]->exportPOV(fp,tab+tabsize,tabsize,anim,false);	
	printTab(fp,tab);
	fprintf(fp,"}\n");	
	//textureBase::exportPOV(fp,tab,tabsize,anim,dummy);



	#ifdef DEBUG
		printf("surface exported (POV)\n");
	#endif

	return 0;
}
