/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentmap.cpp
*/
#include "pigmentmap.h"

#include <misc.h>



pigmentMap::pigmentMap(textureBase *p):textureBase(PIGMENTMAP,p)
{

	setName("Pigmentmap");
	setInfo("Pigmentmap");
	setSubItems(true);

	addAddableItem(PIGMENTENTRY,true);
	addAddableItem(PIGMENT,false);
	addAddableItem(TURBULENCEMODIFIER,true);	
	addAddableItem(TRANSFORMATIONS,true);
}


bool pigmentMap::isEqual(textureBase *tb)
{

#ifdef DEBUG
	printf("Comparing Pigmentmaps..\n");
#endif
	if (!tb) return false;
	if (textureBase::isEqual(tb)==false) return false;


#ifdef DEBUG
	printf("Compared Pigmentmaps..found it !\n");
#endif
	return true;
}

void pigmentMap::add(textureBase *tb)
{
	if (!tb) return;
	addElement(tb,NULL);
}


void pigmentMap::setActive(bool a, textureBase *tb)
{
	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}
	tb->setActive(a,NULL);
}

void pigmentMap::addElement(textureBase* what,textureBase *where)
{
int t;


#ifdef DEBUG
	printf("Adding Pigmentmap-Element (length=%d)\n",elements.length());
#endif

      	if (what==NULL) return;
	if (canAdd(what)==false) return;
	what->setParent(this);
	what->setActive(true,NULL);
	t=what->getType();
	switch (t) {
		case PIGMENT:
		{
			pigmentEntry *ce=new pigmentEntry(this);
			ce->add(what);
			elements.append(ce);
		}
		break;
		default:
			textureBase::addElement(what,where);
		break;
	
	}
	sortPigmentMap();
        updateInfo();
}


void pigmentMap::updateInfo()
{
	char *buffer=(char *)malloc(512);
	
	sprintf(buffer,"Pigmentmap (%d Elements)",elements.length());
	setInfo(buffer);
	free(buffer);
}

patternmodifier *pigmentMap::getMapModifier()
{
	return &modifier;
}
pigmentMap::~pigmentMap()
{
}

void pigmentMap::clearPigmentMap()
{
	textureBase::clearElements();
	updateInfo();
}

void pigmentMap::sortPigmentMap()
{
int a,i,j;
pigmentEntry *ce;

#ifdef DEBUG
	printf("sorting PigmentMap\n");
#endif
	a=elements.length();
	for (i=1;i<a;i++) {
		for (j=0;j<i;j++) {
			if ( ((pigmentEntry*)elements[j])->getRange()>((pigmentEntry*)elements[j+1])->getRange() ) {
				ce=(pigmentEntry*)elements[j+1];
				elements[j+1]=elements[j];
				elements[j]=ce;

			}
		}
	}	
#ifdef DEBUG
	printf("PigmentMap sorted\n");
#endif
	updateInfo();
}
int	pigmentMap::load(media *m,int l)
{
	pigmentEntry *ce;
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;
	setMedia(m);

#ifdef DEBUG
	printf("loading PigmentMap\n");
#endif


	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"PGME",4) == 0) {
			ce=new pigmentEntry(this);
			ce->load(m,len);
			elements.append(ce);
			read=true;
		}
		if(strncmp(chunk,"PATM",4) == 0) {
			modifier.load(m,len);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}	
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *trans=new Transformations(this);
			trans->load(m,len);
			addElement(trans,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }
	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

#ifdef DEBUG
	printf("PigmentMap loaded\n");
#endif
 	sortPigmentMap();
	updateInfo();
	return 0;
}

int	pigmentMap::save(media *m)
{

int i;
	if(!m) return -1;
#ifdef DEBUG
	printf("saving PigmentMap\n");
#endif
	setMedia(m);
	
	writeChunk("PIGM");
	textureBase::save(m);

	for (i=0;i<elements.length();i++)  {
		elements[i]->save(m);			
	}
	modifier.save(m);

	writeChunkLen();

	#ifdef DEBUG
		printf("PigmentMap saved\n");
	#endif*/
	return 0;

}

int pigmentMap::exportPOV(FILE *fp,int tab,int tabsize,int a,bool dummy)
{
int i;
	if(!fp)	return -1;

#ifdef DEBUG
	printf("exporting PigmentMap (POV)\n");
#endif


	modifier.exportPOV(fp,tab,tabsize,a,false);
	printTab(fp,tab);
	fprintf(fp,"pigment_map { //%s\n",getName() );	
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==PIGMENTENTRY)) elements[i]->exportPOV(fp,tab+tabsize,tabsize,a,false);			
	}
	
	printTab(fp,tab);
	fprintf(fp,"}\n" );	

	exportPOV(fp,tab,tabsize,a,dummy);

	#ifdef DEBUG
		printf("PigmentMap exported (POV)\n");
	#endif
	return 0;
}

