/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigment.cpp
*/
#include "pigment.h"

/* XPM */
const char*pigmentfolder[]={
"15 13 6 1",
"d c #000000",
"b c #ffff00",
". c None",
"# c #999999",
"a c #cccccc",
"c c #ffffff",
"..#####........",
".#ababa#.......",
"#abababa######.",
"#cccccccccccc#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"##############d",
".dddddddddddddd"};


pigment::pigment(textureBase *p) :textureBase(PIGMENT,p)
{
int i;
	setName("Pigment");
        setInfo("Pigment");
	setSubItems(true);	

	for(i = 0;i < 20;i++)
		PicBuf[i] = 0;

  	quickcolor = new color(0);

	addAddableItem(COLOR,true);
	addAddableItem(COLORENTRY,false);
	addAddableItem(COLORLIST,true);
	addAddableItem(COLORMAP,true);
	addAddableItem(PIGMENT,false);
	addAddableItem(PIGMENTLIST,true);
	addAddableItem(PIGMENTMAP,true);
	addAddableItem(IMAGEMAP,true);
	addAddableItem(TRANSFORMATIONS,true);
	addAddableItem(TURBULENCEMODIFIER,true);
	addAddableItem(WARP,true);

}

pigment::~pigment()
{
	int	i;
	
	for(i = 0;i < 20;i++)
		if(PicBuf[i])
		{
			free(PicBuf[i]);
			PicBuf[i] = 0;
		}
		
	if(quickcolor)
		delete quickcolor;
}

const char **pigment::getXPM()
{
	int	r = (int)(quickcolor->red() * 255);
	int	g = (int)(quickcolor->green() * 255);
	int	b = (int)(quickcolor->blue() * 255);
	char	*buffer1,*buffer2;
	int	i;
	
	buffer1=(char *)malloc(128);
	buffer2=(char *)malloc(128);
	sprintf(buffer1,"b\tc #%02x%02x%02x",r,g,b);

	for(i = 0;i < 20;i++)
		if (PicBuf[i])
		{
			delete PicBuf[i];
			PicBuf[i] = 0;
		}
	
	for(i = 0;i < 20;i++)
	{
		PicBuf[i] = strdup(pigmentfolder[i]);
	}
	strncpy(PicBuf[2],buffer1,11); //Color

	free(buffer1);
	free(buffer2);

	return (const char **)&PicBuf;
}


void	pigment::setActive(bool a,textureBase *tb)
{
int i;

	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}

	if ((tb->getType()==TURBULENCEMODIFIER)||
	     (tb->getType()==TRANSFORMATIONS) ||
		(tb->getType()==WARP)) {
			tb->setActive(a);
			return;
	}

	if (a==false) return;
	for (i=0;i<elements.length();i++) elements[i]->setActive(false);
	tb->setActive(true);
}

void pigment::addElement(textureBase* what,textureBase* where)
{
	if (what==NULL) return;
	what->setParent(this);
	setActive(true,what);
	switch(what->getType()) {
	case COLORENTRY:
	{
		color *c=new color(this);
		c->add(what);
		elements.append(c);
	}
	break;
	default:
		textureBase::addElement(what,where);
	break;
	}
}

void pigment::setQuickColor(color *c)
{
	if (quickcolor) delete quickcolor;
	quickcolor=c;
}

color *pigment::getQuickColor(textureBase *tb)
{

	return quickcolor;
}

void pigment::add(textureBase *tb)
{
	if (!tb) return
	tb->setParent(this);	
	addElement( tb,NULL);
}

bool pigment::isEqual(textureBase *tb)
{
#ifdef DEBUG
	printf("Comparing Pigments..\n");
#endif

	if (!tb) return false;
	if (textureBase::isEqual(tb)==false) return false;

#ifdef DEBUG
	printf("Compared Pigments..found it !\n");
#endif
	return true;

}


int	pigment::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();
	double a;

	if(!m) return -1;
	setMedia(m);
#ifdef DEBUG
	printf("loading pigment\n");
#endif

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"QUIC",4) == 0) {
			m->read(&a,sizeof(double));
			quickcolor->setRed(a);
			m->read(&a,sizeof(double));
			quickcolor->setGreen(a);
			m->read(&a,sizeof(double));
			quickcolor->setBlue(a);
			read=true;	
		}

		if(strncmp(chunk,"COLR",4) == 0) {
			color *col=new color(this);
			col->load(m,len);
			addElement(col,NULL);
			read=true;
		}
		if(strncmp(chunk,"COLL",4) == 0) {
			colorList *colList=new colorList(this);
			colList->load(m,len);
			addElement(colList,NULL);
			read=true;
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *trans=new Transformations(this);
			trans->load(m,len);
			addElement(trans,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);
			read=true;
		}
		if(strncmp(chunk,"COLM",4) == 0) {
			colorMap *colMap=new colorMap(this);
			colMap->load(m,len);
			addElement(colMap,NULL);
			read=true;

		}
		if(strncmp(chunk,"WARP",4) == 0) {
			warp *w=new warp(this);
			w->load(m,len);
			addElement(w,NULL);
			read=true;
		}
		if(strncmp(chunk,"IMGM",4) == 0) {
			imageMap *imgMap=new imageMap(this);
			imgMap->load(m,len);
			addElement(imgMap,NULL);
			read=true;
		}
		if(strncmp(chunk,"PIGM",4) == 0) {
			//pigmentMap *pigMap=new pigmentMap(this);
			//pigMap->load(fp,len-4);
			//ddElement(pigMap,NULL);			
			//read=true;
		}
		if(strncmp(chunk,"PIGL",4) == 0) {
			//pigmentList *pigList=new pigmentList(this);
			//pigList->load(fp,len-4);
			//addElement(pigList,NULL);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );

	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...  c
#ifdef DEBUG
	printf("loaded pigment\n");
#endif
	return 0;
}

int	pigment::save(media *m)
{
double a;
int i;
chunk c;

	if(!m) return -1;

	setMedia(m);
#ifdef DEBUG
	printf("saving pigment\n");
#endif
	writeChunk("PGMT");

	textureBase::save(m);

	c.setMedia(m);
	c.writeChunk("QUIC");
		a=quickcolor->red();
		m->write(&a,sizeof(double));
		a=quickcolor->green();
		m->write(&a,sizeof(double));
		a=quickcolor->blue();
		m->write(&a,sizeof(double));
	c.writeChunkLen();


	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}


	writeChunkLen();

#ifdef DEBUG
	printf("pigment saved\n");
#endif
	return 0;
}

int	pigment::exportPOV(FILE *fp,int tab,int tabsize,int a, bool dummy)
{
int i;

	#ifdef DEBUG
		printf("Exporting Pigment (POV)\n");
	#endif

	if(fp == 0)
		return -1;

	printTab(fp,tab);
	fprintf(fp,"pigment  //Name:%s\n",name);

	printTab(fp,tab);
	fprintf(fp,"{\n");

	for (i=0;i<elements.length();i++) {
		if (elements[i]->active()==true) {
			if ((elements[i]->getType()!=WARP)&&
				(elements[i]->getType()!=TURBULENCEMODIFIER)&&
				(elements[i]->getType()!=TRANSFORMATIONS))
				elements[i]->exportPOV(fp,tab+tabsize,tabsize,a,dummy);
		}
	}

	printTab(fp,tab+tabsize);
	fprintf(fp,"quick_color rgb<%g,%g,%g>\n",quickcolor->red(),quickcolor->green(),quickcolor->blue());	

	textureBase::exportPOV(fp,tab,tabsize,a,dummy);

	printTab(fp,tab);
        fprintf(fp,"}\n");

	#ifdef DEBUG
		printf("Exported Pigment (POV)\n");
	#endif

	return 0;
}

