/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normallist.cpp
*/
#include "normallist.h"
#include "normalentry.h"
#include <misc.h>

static char	fnname[normalList::NFunctions][20] =
		{
		"brick",
		"checker",
		"hexagon"
		};


normalList::normalList(textureBase *p):textureBase(NORMALLIST,p)
{
	fn=Checker;

	setName("Normallist");
	setInfo("Normallist");
	setSubItems(true);

	addAddableItem(NORMAL,true);
	addAddableItem(TURBULENCEMODIFIER,true);
	addAddableItem(TRANSFORMATIONS,true);

}

void normalList::addElement(textureBase* what,textureBase* where)
{
        if(!what) return;
	what->setParent(this);
	what->setActive(true);
	switch (what->getType()) {
	default:
		textureBase::addElement(what,where);
	break;
	}
	updateInfo();
}

bool normalList::isEqual(textureBase *tb)
{
#ifdef DEBUG
	printf("Comparing Normallist...\n");
#endif

	if (!tb) return false;
      	if (textureBase::isEqual(tb)==false) return false;	
	if ( ((normalList*)tb)->getNormalListFunction()!=fn) return false;

#ifdef DEBUG
	printf("Comparing Normallist...found !\n");
#endif
	return true;
}

void normalList::updateInfo()
{
char *buffer=(char *)malloc(512);
	sprintf(buffer,"Pattern:%s",getNormalListFunctionName());
	setInfo(buffer);
	free(buffer);
}

normalList::~normalList()
{
}

void normalList::setNormalListFunction(FUNCTION f)
{
	fn=f;
}

int normalList::getNormalListFunction()
{
	return fn;
}

char *normalList::getNormalListFunctionName()
{
	return fnname[fn];
}

char *normalList::getNormalListFunctionNameList(int n)
{
	return fnname[n];
}

int	normalList::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;
	
	#ifdef DEBUG
		printf("loading NormalList\n");
	#endif

	setMedia(m);

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"NRML",4) == 0) {
			normal *no=new normal(this);
			no->load(m,len);
			addElement(no,NULL);
			read=true;
		}
		if(strncmp(chunk,"NLFN",4) == 0) {
			m->read(&fn,4);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *tr=new Transformations(this);
			tr->load(m,len);
			addElement(tr,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);		
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );


	m->seek(pos+l,SEEK_SET);

	#ifdef DEBUG
		printf("NormalList loaded\n");
	#endif

	updateInfo();
	return 0;
}


void	normalList::add(textureBase *tb)
{
	if (tb==NULL) return;
	if (canAdd(tb)==false) return;
	addElement(tb,NULL);

	updateInfo();
}


int	normalList::save(media *m)
{
int i;
chunk ch;
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving NOrmalList\n");
	#endif
	setMedia(m);

	writeChunk("NRLL");

	textureBase::save(m);
        ch.setMedia(m);
	ch.writeChunk("NLFN");
		m->write(&fn,4);
	ch.writeChunkLen();

	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}

	writeChunkLen();

	#ifdef DEBUG
		printf("NormalList saved\n");
	#endif
	return 0;
}

int normalList::exportPOV(FILE *fp,int tab,int tabsize,int a, bool dummy)
{
int i;
	if(fp == 0)
		return -1;
	#ifdef DEBUG
		printf("exporting NormalList (POV)\n");
	#endif
	
	printTab(fp,tab);
	fprintf(fp,"%s  //%s\n",getNormalListFunctionName(),getName() );

	for (i=0;i<elements.length();i++) {
		if (elements[i]->active()==true) {
				printTab(fp,tab);
				fprintf(fp,"normal {\n");
				printTab(fp,tab+tabsize);
				if (elements[i]->active()==true) elements[i]->exportPOV(fp,tab+tabsize,tabsize,a,dummy);
				printTab(fp,tab);
				fprintf(fp,"}\n");

		}
	}

	textureBase::exportPOV(fp,tab,tabsize,a,dummy);
	
 	#ifdef DEBUG
		printf("NormalList exported (POV)\n");
	#endif

	return 0;
}
