/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** imagemap.h
*/
#ifndef __IMAGEMAP_H__
#define __IMAGEMAP_H__

#include <misc.h>

#include "texturebase.h"
#include "bitmapmodifier.h"
#include "../classes/imageconverter.h"


class imageMap : public textureBase
{
protected:

	char		*Filename;
	char		*Filetype;
	char		*realFileName;
	char		*realFileType;
	double		FilterValue;
	double		TransmitValue;
	bitmapmodifier	modifier;

	char		*picData;
	int		picLen;

public:

	imageMap(textureBase *p=0);
	~imageMap();

	const char	*getImageMapFilename();
	void		setImageMapFilename(const char *);

	void		setImageMapFiletype(const char *);
	const char	*getImageMapFiletype();

	void		setImageMapFilterValue(double);
	double		getImageMapFilterValue();

	void		setImageMapTransmitValue(double);
	double		getImageMapTransmitValue();

	char		*getInfo();

	bitmapmodifier	*getModifier();

	void		add(textureBase *);
	bool		isEqual(textureBase *);

	void		updateInfo();

	int		save(media*);
	int		load(media*,int);

	int		exportPOV(FILE*,int,int,int,bool);
};


#endif


