/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** finish.cpp
*/
#include "finish.h"

#include <misc.h>

finish::finish(textureBase *p):textureBase(FINISH,p)
{
	#ifdef DEBUG
		printf("Entering Finish-Constructor\n");
	#endif

	ambient = new color(this);
	ambient->setRed(0.1);
	ambient->setGreen(0.1);
	ambient->setBlue(0.1);

	diffuse = 0.6;
	brilliance = 1;

	phong = 0;
	phong_size = 40;
	specular = 0;
	roughness = 0.05;
	metallic = false;

	reflection = 0;
	irid_amount = 0;
	irid_thickness = 0.5;
	irid_turbulence = 0;

	setName("Finish");
	setInfo("Finish");
	setSubItems(true);

	#ifdef DEBUG
		printf("Exiting Finish-Constructor\n");
	#endif
}

finish::~finish()
{
	if(ambient)
		delete ambient;
}

void	finish::setActive(bool a,textureBase *tb)
{
	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}

	if ((tb->getType()==TURBULENCEMODIFIER)||
	     (tb->getType()==TRANSFORMATIONS)) {
			tb->setActive(a);
			return;
	}
}

void finish::addElement(textureBase* what,textureBase* where)
{
int t=-1;
finish *f=(finish *)what;
	if (what==NULL) return;

	if (what->getType()==FINISH) {
		ambient->add(f->getAmbient() );
		diffuse = f->getDiffuse();
		brilliance = f->getBrilliance();
		phong = f->getPhong();
		phong_size = f->getPhongSize();
		specular = f->getSpecular();
		roughness = f->getRoughness();
		metallic = f->getMetallic();
		reflection = f->getReflection();
		irid_amount = f->getIridAmount();
		irid_thickness = f->getIridThickness();
		irid_turbulence = f->getIridTurbulence();
		return;
	}
	what->setParent(this);
	setActive(true,what);
/*
	if (what->getType()==TRANSFORMATIONS) {
		for (i=0;i<elements.length();i++){
			if (elements[i]->getType()==TRANSFORMATIONS) {
				elements.deleteAt(i);
				elements.append(what);
				return;
			}
		}			
	}
	if (what->getType()==TURBULENCEMODIFIER) {
		for (i=0;i<elements.length();i++){
			if (elements[i]->getType()==TURBULENCEMODIFIER) {
				elements.deleteAt(i);
				elements.append(what);
				return;
			}
		}			
	}
*/
	if (where) t=elements.find(where);
	if ((where==NULL)||(t==-1)) {
#ifdef DEBUG
	printf("Adding Finish-Element (l=%d)\n",elements.length());
#endif
		elements.append(what);
		return;
	}
	elements.insertAt(what,t);
}

bool finish::isEqual(textureBase *tb)
{
finish *f=(finish*)tb;
textureBase *tb1;
int i;
	if (tb->getType()!=FINISH) return false;
#ifdef DEBUG
	printf("Comparing Finish..\n");
#endif
	if (
		(ambient->isEqual(f->getAmbient())==true)&&
		(diffuse == f->getDiffuse() )&&
		(brilliance == f->getBrilliance() )&&
		(phong == f->getPhong() ) &&
		(phong_size == f->getPhongSize() )&&
		(specular == f->getSpecular() )&&
		(roughness == f->getRoughness() )&&
		(metallic == f->getMetallic() )&&
		(reflection == f->getReflection() )&&
		(irid_amount == f->getIridAmount() )&&
		(irid_thickness == f->getIridThickness() ) &&
		(irid_turbulence == f->getIridTurbulence() ) &&
		(textureBase::isEqual(tb)==true)
	) {
		tb1=tb->getFirstElement();
		if ( ( (tb1==NULL)&&(elements.length()==0) ) ) return true;
		for (i=0;i<elements.length();i++) {
     			if (tb1==NULL) return false;
			if (tb1->isEqual(elements[i])==false) return false;
			tb1=tb->getNextElement();		
		}
#ifdef DEBUG
	printf("Compared Pigments..found it !\n");
#endif
		return true;
	}
	return false;
}

void finish::add(textureBase *tb)
{
	if (canAdd(tb)==false) return;
	addElement(tb,NULL);

}

void finish::setMetallic(bool b)
{
	metallic=b;
}

bool finish::getMetallic()
{
	return metallic;
}

void	finish::setAmbient(color *c)
{
	if (ambient) delete ambient;
	ambient = c;

}

color	*finish::getAmbient()
{
	return ambient;
}


void	finish::setReflection(double d)
{
	reflection=d;
}


double	finish::getReflection()
{
	return reflection;
}


void finish::setBrilliance(double a)
{	
	brilliance=a;
}

double finish::getBrilliance()
{
	return brilliance;
}

void finish::setPhong(double a)
{	
	phong=a;
}

double finish::getPhong()
{
	return phong;
}

void finish::setPhongSize(double a)
{	
	phong_size=a;
}

double finish::getPhongSize()
{
	return phong_size;
}

void finish::setSpecular(double a)
{	
	specular=a;
}

double finish::getSpecular()
{
	return specular;
}

void finish::setRoughness(double a)
{	
	roughness=a;
}

double finish::getRoughness()
{
	return roughness;
}



void finish::setIridAmount(double a)
{	
	irid_amount=a;
}

double finish::getIridAmount()
{
	return irid_amount;
}

void finish::setIridThickness(double a)
{	
	irid_thickness=a;
}

double finish::getIridThickness()
{
	return irid_thickness;
}

void finish::setIridTurbulence(double v)
{	
	irid_turbulence=v;
}

double finish::getIridTurbulence()
{
	return irid_turbulence;
}

void finish::setDiffuse(double a)
{	
	diffuse=a;
}

double finish::getDiffuse()
{
	return diffuse;
}
int	finish::load(media *m,int l)
{
	double x;
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();
	

	if(!m)	return -1;

	#ifdef DEBUG
		printf("Loading Finish\n");
	#endif

	setMedia(m);


	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"DAF1",4) == 0) {
			m->read(&x,sizeof(double)) ;
			ambient->setRed(x);
			m->read(&x,sizeof(double)) ;
			ambient->setGreen(x);	
			m->read(&x,sizeof(double)) ;
			ambient->setBlue(x);
			m->read(&diffuse,sizeof(double)) ;
			m->read(&brilliance,sizeof(double)) ;
			read=true;			
		}
		if(strncmp(chunk,"DAF2",4) == 0) {
			m->read(&phong,sizeof(double)) ;
			m->read(&phong_size,sizeof(double)) ;
			m->read(&specular,sizeof(double)) ;
			m->read(&roughness,sizeof(double)) ;
			m->read(&metallic,sizeof(bool)) ;
			read=true;			
		}
		if(strncmp(chunk,"DAF3",4) == 0) {
			m->read(&reflection,sizeof(double)) ;	
			m->read(&irid_amount,sizeof(double)) ;	
			m->read(&irid_thickness,sizeof(double)) ;	
			m->read(&irid_turbulence,sizeof(double)) ;	
			read=true;			
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *trans=new Transformations(this);
			trans->load(m,len);
			addElement(trans,NULL);
			read=true;	
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );

	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...


	#ifdef DEBUG
		printf("Loaded Finish\n");
	#endif

	return 0;
}

int	finish::save(media *m)
{
double x;
int i;
chunk ch;

	if(!m) return -1;

	#ifdef DEBUG
		printf("Saving Finish\n");
	#endif

	setMedia(m);
	ch.setMedia(m);	

	writeChunk("FNSH");

	textureBase::save(m);
	
	ch.writeChunk("DAF1");
		x=ambient->red();
		m->write(&x,sizeof(double)) ;
		x=ambient->green();
		m->write(&x,sizeof(double)) ;
		x=ambient->blue();
		m->write(&x,sizeof(double)) ;
		m->write(&diffuse,sizeof(double)) ;
		m->write(&brilliance,sizeof(double)) ;
	ch.writeChunkLen();

	
	ch.writeChunk("DAF2");
		m->write(&phong,sizeof(double)) ;
		m->write(&phong_size,sizeof(double)) ;
		m->write(&specular,sizeof(double)) ;
		m->write(&roughness,sizeof(double)) ;
		m->write(&metallic,sizeof(bool)) ;
	ch.writeChunkLen();

	ch.writeChunk("DAF3");
		m->write(&reflection,sizeof(double)) ;	
		m->write(&irid_amount,sizeof(double)) ;	
		m->write(&irid_thickness,sizeof(double)) ;	
		m->write(&irid_turbulence,sizeof(double)) ;	
	ch.writeChunkLen();

	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}

	writeChunkLen();

	#ifdef DEBUG
		printf("Saved Finish\n");
	#endif


	return 0;
}

bool	finish::isExportable()
{
	if ((!((ambient->red()==0.1)&&(ambient->green()==0.1)&&(ambient->blue()==0.1)))
	&& (brilliance==1)
	&& (diffuse==0.6)
	&& (phong==0)
	&& (phong_size==40)
	&& (roughness==0.05)
	&& (specular==0)
	&& (metallic==false)
	){
		return false;
	}
	return true;
}

int	finish::exportPOV(FILE *fp,int tab,int tabsize,int a,bool x)
{
int i;

	if(fp == 0) return -1;
	#ifdef DEBUG
		printf("Exporting Finish (POV)\n");
	#endif
	//if (!isExportable() ) return 0;


	printTab(fp,tab);
	fprintf(fp,"finish  //Name:%s\n",name);
	
	printTab(fp,tab);
	fprintf(fp,"{\n");

	if (!((ambient->red()==0.1)&&(ambient->green()==0.1)&&(ambient->blue()==0.1))) {
		printTab(fp,tab + tabsize);
		fprintf(fp,"ambient          rgb<%g,%g,%g>\n",ambient->red(),ambient->green(),ambient->blue());
	}
	if (diffuse!=0.6) {
		printTab(fp,tab + tabsize);
		fprintf(fp,"diffuse          %g\n",diffuse);
	}
	if (brilliance!=1) {
		printTab(fp,tab + tabsize);
		fprintf(fp,"brilliance       %g\n",brilliance);
	}

	if (phong!=0) {
		printTab(fp,tab + tabsize);
		fprintf(fp,"phong            %g\n",phong);
		if (phong_size!=40) {
			printTab(fp,tab + tabsize);
			fprintf(fp,"phong_size       %g\n",phong_size);
		}
	}
	if (specular!=0) {
		printTab(fp,tab + tabsize);
		fprintf(fp,"specular         %g\n",specular);
	}
	if (roughness!=0.05) {
		printTab(fp,tab + tabsize);
		fprintf(fp,"roughness        %g\n",roughness);
	}

	if(metallic != false)
	{
		printTab(fp,tab + tabsize);
		fprintf(fp,"metallic\n");
	}
	if (reflection!=0) {
		printTab(fp,tab + tabsize);
		fprintf(fp,"reflection       %g\n",reflection);
	}

	if(irid_amount != 0)
	{
		printTab(fp,tab + tabsize);
		fprintf(fp,"irid\n");
		printTab(fp,tab + tabsize);
		fprintf(fp,"{\n");
		
		printTab(fp,tab + tabsize * 2);
		fprintf(fp,"%g\n",irid_amount);
		printTab(fp,tab + tabsize * 2);
		fprintf(fp,"thickness   %g\n",irid_thickness);
		printTab(fp,tab + tabsize * 2);
		fprintf(fp,"turbulence  %g\n",irid_turbulence);

		printTab(fp,tab + tabsize);
		fprintf(fp,"}\n");
	}

	for (i=0;i<elements.length();i++) {
		if ((elements[i]->active()==true)&&
		(elements[i]->getType()!=TURBULENCEMODIFIER)&&
		(elements[i]->getType()!=TRANSFORMATIONS))
		 {
		elements[i]->exportPOV(fp,tab,tabsize,a,false);
		}
	}
/*
	for (i=0;i<elements.length();i++) {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==TURBULENCEMODIFIER)) elements[i]->exportPOV(fp,tab,tabsize,a,false);	
	}
	for (i=0;i<elements.length();i++) {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==TRANSFORMATIONS)) elements[i]->exportPOV(fp,tab,tabsize,a,false);	
	}
*/
	printTab(fp,tab);
	fprintf(fp,"}\n");

	#ifdef DEBUG
		printf("Exported Finish (POV)\n");
	#endif
	return 0;
}

