/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colormap.cpp
*/
#include "colormap.h"

#include <misc.h>



colorMap::colorMap(textureBase *p):textureBase(COLORMAP,p)
{

	setName("Colormap");
	setInfo("Colormap");
	setSubItems(true);

	addAddableItem(COLOR,false);
	addAddableItem(COLORENTRY,true);
	addAddableItem(COLORMAP,false);
	addAddableItem(COLORLIST,false);
	addAddableItem(PATTERNMODIFIER,true);
}


void colorMap::add(textureBase *tb)
{
	if (!tb) return;
	addElement(tb,NULL);
}

void colorMap::setActive(bool a, textureBase *tb)
{
	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}
	tb->setActive(a,NULL);
}

void colorMap::addElement(textureBase* what,textureBase *where)
{
int t;

#ifdef DEBUG
	printf("Adding Colormap-Element (length=%d)\n",elements.length());
#endif

      	if (!what) return;
	if (canAdd(what)==false) return;
	what->setParent(this);
	what->setActive(true,NULL);
	t=what->getType();
	switch (t) {
		case COLOR:
		{
			colorEntry *ce=new colorEntry(this);
			ce->add(what);
			elements.append(ce);
		}
		break;
		case COLORLIST:
		{
		textureBase *tb=what->getFirstElement();
			while(tb!=NULL) {
				colorEntry *ce=new colorEntry(this);
				ce->add( (color *)tb);
				elements.append(ce);
				tb=what->getNextElement();					
			}
		}
		break;
		default:
			textureBase::addElement(what,where);
		break;
	
	}
	sortColorMap();
        updateInfo();
}


void colorMap::updateInfo()
{
	char *buffer=(char *)malloc(512);
	
	sprintf(buffer,"Colormap (%d Elements)",elements.length());
	setInfo(buffer);
	free(buffer);
}

patternmodifier *colorMap::getMapModifier()
{
	return &modifier;
}

colorMap::~colorMap()
{
	clearColorMap();
}

void colorMap::clearColorMap()
{
	textureBase::clearElements();
	updateInfo();
}

void colorMap::sortColorMap()
{
int a,i,j;
colorEntry *ce;

#ifdef DEBUG
	printf("sorting ColorMap\n");
#endif
	a=elements.length();
	for (i=1;i<a;i++) {
		for (j=0;j<i;j++) {
			if ( ((colorEntry*)elements[j])->getRange()>((colorEntry*)elements[j+1])->getRange() ) {
				//printf("swapped\n");
				ce=(colorEntry*)elements[j+1];
				elements[j+1]=elements[j];
				elements[j]=ce;

			}
		}
	}	
#ifdef DEBUG
	printf("ColorMap sorted\n");
#endif
	updateInfo();
}
int	colorMap::load(media *m,int l)
{
	colorEntry *ce;
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;
	setMedia(m);

#ifdef DEBUG
	printf("loading ColorMap\n");
#endif


	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"COLE",4) == 0) {
			ce=new colorEntry(this);
			ce->load(m,len);
			elements.append(ce);
			read=true;
		}
		if(strncmp(chunk,"PATM",4) == 0) {
			modifier.load(m,len);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}	
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *trans=new Transformations(this);
			trans->load(m,len);
			addElement(trans,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }
	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

#ifdef DEBUG
	printf("ColorMap loaded\n");
#endif
 	sortColorMap();
	updateInfo();
	return 0;
}

int	colorMap::save(media *m)
{

int i;
	if(!m) return -1;
#ifdef DEBUG
	printf("saving ColorMap\n");
#endif
	setMedia(m);
	
	writeChunk("COLM");
	textureBase::save(m);

	for (i=0;i<elements.length();i++)  {
		elements[i]->save(m);			
	}
	modifier.save(m);

	writeChunkLen();

	#ifdef DEBUG
		printf("ColorMap saved\n");
	#endif*/
	return 0;

}

int colorMap::exportPOV(FILE *fp,int tab,int tabsize,int a,bool dummy)
{
int i;
	if(!fp)	return -1;

#ifdef DEBUG
	printf("exporting ColorMap (POV)\n");
#endif


	modifier.exportPOV(fp,tab,tabsize,a,false);
	printTab(fp,tab);
	fprintf(fp,"color_map { //%s\n",getName() );	
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==COLORENTRY)) elements[i]->exportPOV(fp,tab+tabsize,tabsize,a,false);			
	}

	textureBase::exportPOV(fp,tab,tabsize,a,dummy);

	printTab(fp,tab);
	fprintf(fp,"}\n" );	


	#ifdef DEBUG
		printf("ColorMap exported (POV)\n");
	#endif
	return 0;
}

