/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colorentry.h
*/
#ifndef __COLORENTRY_H__
#define __COLORENTRY_H__

#include <misc.h>
#include <list.h>
#include "color.h"
#include <stdio.h>


class colorEntry:public textureBase
{
protected:
	double r,g,b,t,f,range;
	void updateInfo();
	char *PicBuf[30];

public:
	colorEntry(textureBase *p=NULL);
	~colorEntry();

	void setRange(double);
	double getRange();

	const char **getXPM();

	double	getRed();
	double	getGreen();
	double	getBlue();
	double	getTransparency();
	double	getFilter();

	void 	setRed(double);
	void 	setGreen(double);
	void 	setBlue(double);
	void 	setTransparency(double);
	void 	setFilter(double);

	void	add(textureBase *);

	bool	isEqual(textureBase *);

	int	save(media*);
	int	load(media*,int);

	int	exportPOV(FILE*,int,int, int,bool);
};

#endif
