/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** text.h
*/
#ifndef __TEXT_H__
#define __TEXT_H__

#include <font.h>

#include <classes.h>

class cmesh;

class text : public csgobj
{
protected:
	char		*fontname;
	char		*context;
	double		thickness;	// z-Ausdehnung
	Vector2		offset;		// default:0, ansonsten Buchstabenabstand fr x und y

	fontglyph	**fontcache;
	font		*fontptr;

public:

	text(base *b=0,const char *n="Untitled",const char *tx="Text",const char *f="arial.ttf",double th=1,texture *t=0);
	text(base*,const char*,const char*,const char*,double,Vector2&,texture*,Vector3&,Vector3&,Vector3&);
	text(base*,const char*,const char*,const char*,double,Vector2&,Vector3&,Vector3&,Vector3&);
	text(base*,text*);
	~text();

	virtual int	addToParent(base *p);
	virtual int	removeFromParent();

	virtual base	*copy(base*);

	virtual int	exportPOV(FILE *,int,int,int);
	virtual void	dumpNames(int,int);

	virtual int	save(media*,int);
	virtual int	load(media*,int,int);

	virtual int	draw(view*,Matrix44,int);
	virtual int	calculate(int);

	char		*getText();
	void		setText(const char *txt);
	char		*getFontName();
	void		setFontName(const char *fn);
	double		getThickness();
	void		setThickness(double t);
	Vector2		getOffset();
	void		setOffset(Vector2 &o);

	void		setFontPath(const char*);

	int		getMesh(cmesh*);

	virtual double	volume(int anim = 0);

private:
	int		drawSpline(view*,Matrix44,Vector2*,int,double,double,int);
	int		addMeshSpline(cmesh*,simplelist<Vector2>,double,double);

};

#endif


