/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** ref.h
*/
#ifndef __REF_H__
#define __REF_H__

#include <classes.h>

#include "refptr.h"

class ref : public base
{
protected:
	list<refptr*>	reflist;
	list<body*>	objectlist;

public:
	ref(base *p=0,const char *n="Untitled");
	ref(base *p,ref *rc);
	~ref();

	int		getReferenceCounter() {	return reflist.length();};

	virtual int	addToParent(base*);
	virtual int	removeFromParent();

	virtual base	*copy(base*);

	virtual int	addChild(body*);
	virtual int	addChild(refptr*);
	virtual int	addChild(csgobj*);
	virtual int	addChild(blobobj*);
	virtual int	addChild(nonsolid*);
	virtual int	removeChild(body*);
	virtual int	removeChild(refptr*);
	virtual int	removeChild(csgobj*);
	virtual int	removeChild(blobobj*);
	virtual int	removeChild(nonsolid*);

	virtual void	getChildren(base***);

	virtual int	exportPOV(FILE*,int,int,int);

	virtual void	dumpNames(int,int);

	virtual int	existsName(const char*);
	virtual base	*searchName(const char*);

	virtual int	save(media*,int);
	virtual int	load(media*,int,int);

	virtual int	draw(view*,Matrix44,int);
	virtual int	drawRef(view*,Matrix44,int,int);
	virtual int	calculate(int anim = 0);
};

#endif

