/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** ear.cpp
*/
#include "ear.h"

ear::ear(base *p,const char *n,unsigned int c) :
	body(p,n)
{
	numtype = NUM_EAR;

	if(parent)
		addToParent(parent);

	setChannel(c);
}

ear::ear(base *p,ear *cc) :
	body(p,cc)
{
	numtype = NUM_EAR;

	if(parent)
		addToParent(parent);

	setChannel(cc->getChannel());
}

ear::~ear()
{
	// workaround
	removeFromParent();
}

void	ear::setChannel(unsigned int c)
{
	channel = c;
}

unsigned int	ear::getChannel()
{
	return channel;
}

int	ear::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;

	return p->addChild(this);
}

int	ear::removeFromParent()
{
	if(!parent) return -2;

	return parent->removeChild(this);
}

base	*ear::copy(base *p)
{
	return new ear(p,this);
}

int	ear::exportPOV(FILE *,int,int,int)
{
	return 0;
}

int	ear::calculate(int)
{
	return 0;
}

int	ear::draw(view *v,Matrix44 m,int anim)
{
	return -1;
}

void	ear::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("ear: %s (%i)\n",name,channel);
}

int	ear::save(media *m,int ver)
{
	if(!m) return -1;

	switch(ver)
	{
		case 0:
		case -1:
			setMedia(m);
			writeChunk("EAR ");
			writeNameChunk(name);
			saveFlags(m);

			writeInt(channel);
	
			anim::save(m);
			transform::save(m,ver);

			writeChunkLen();
		break;
		default:
			return -2;
	}

	return 0;
}

int	ear::load(media *m,int l,int ver)
{
	int	pos = m->tell();

	switch(ver)
	{
		case 0:
		case -1:
			loadFlags(m,l);

			channel = readInt();
			
			anim::load(m,l - (m->tell() - pos));
			transform::load(m,l - (m->tell() - pos),ver);
		break;
		default:
			return -2;
	}

	return 0;
}

double	ear::volume(int)
{
	return 0;
}



