/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** body.cpp
*/
#include "body.h"
#include "world.h"

body::body(base *p,const char *n,texture *t)
 : transform(p,n)
{
	texptr = t;
	d_weight = 1;
}

body::body(base *p,const char *n,texture *t,Vector3 &vs,Vector3 &vr,Vector3 &vt)
 : transform(p,n,vs,vr,vt)
{
	texptr = t;
	d_weight = 1;
}

body::body(base *p,const char *n,Vector3 &vs,Vector3 &vr,Vector3 &vt)
 : transform(p,n,vs,vr,vt)
{
	texptr = 0;
	d_weight = 1;
}

body::body(base *p,body *bc)
 : transform(p,bc)
{
	texptr = bc->texptr;
	d_weight = 1;
}

body::~body()
{
}

void		body::setTexture(texture *t)
{
	TextureLibrary 	*tl;
        base		*b;

	b = getRoot();

	if(b->getType() == NUM_WORLD)
	{
		tl = ((world*)b)->getTextureLibrary();
		if(tl)
		{
			texptr = tl->findTextureStruct(t);
		}
	}
}

texture		*body::getTexture()
{
	return texptr;
}

int		body::saveTexture(media *m)
{
	if(texptr)
	{
		texptr->savePtr(m);
	}

	return 0;
}

int		body::loadTexture(media *m,int)
{
	char		chunk[4],*tn;
	int		len = 0;

	setMedia(m);

	m->read(chunk,4);
	m->read(&len,4);

	if(strncmp(chunk,"TXTP",4) != 0) return -1;

	tn = readName();

	texptr = findTexture(tn);

	return 0;
}

texture		*body::findTexture(char *n)
{
	world		*myworld;
	base		*b;
	TextureLibrary	*tl;
	char		buffer[1024];
	char		*cp;

	if(n == 0) return 0;

	strcpy(buffer,n);
	cp=strrchr(buffer,'/');
	if (cp)
		*cp=0;


	//for(b = this;b->getParent() && b->getType() != NUM_WORLD;b = b->getParent());

	b = getRoot();

	if(b->getType() != NUM_WORLD) return 0;

	myworld = (world*)b;
	if((tl = myworld->getTextureLibrary()) == 0) return 0;

	return tl->findTexturePath(buffer);
}

void		body::setSpecificWeight(double w)
{
	d_weight = w;
}

double		body::specificWeight()
{
	return d_weight;
}

double		body::weight()
{
	return specificWeight() * volume();
}



