/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** percentwidget.cpp
*/

#include <klocale.h>
#include "percentwidget.h"
#include "percentwidget.moc"

#include <stdio.h>
#include <qslider.h>

//#define stloc(a)	((char*)locale->translate((a)))
#define stloc(a) (a)


PercentWidget::PercentWidget(QWidget *parent,char *name,double v) :
	QWidget(parent,name)
{

	value=v;

	slider=new QSlider(this);

	slider->setRange(0,100);
	slider->setSteps(1,1);
	slider->setOrientation(QSlider::Horizontal);
	slider->setValue( (int)(v*100) );

	label=new QLabel(name,this);
	valuel=new QLabel(this);
	
	connect(slider,SIGNAL(valueChanged(int)),this,SLOT(changed(int)) );	

}

PercentWidget::~PercentWidget()
{
}

void PercentWidget::changed(int x)
{
        QString buf;

	value=(double)(x/100.0);
	buf.setNum(value);
	valuel->setText(buf);

}

double PercentWidget::getValue()
{
	return value;
}

void PercentWidget::setValue(double v)
{
        QString buf;

	value=v;
	buf.setNum(value);
	valuel->setText(buf);
}

void PercentWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	//int h=height();
        QString buf;
        QSize qs;

	buf.setNum(value);
	valuel->setText( buf);
        qs=label->sizeHint();

	label->setGeometry(0,0,qs.width(),25);
	slider->setGeometry(qs.width()+5,0,w-qs.width()-42,25);
	valuel->setGeometry(w-35,0,35,25);	

	QWidget::paintEvent(qp);

}
