/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** mapmodifierdialog.cpp
*/
#include <qslider.h>
#include "mapmodifierdialog.h"
#include "mapmodifierdialog.moc"

#include <klocale.h>


//#define stloc(a)	((char*)locale->translate((a)))
#define stloc(a) (a)


MapModifierDialog::MapModifierDialog(QWidget *parent,const char *name,mapmodifier *p) :
	QDialog(parent,name,true)
{

	modifier = p;
        ok = new QPushButton( "Ok", this ); 
	connect( ok, SIGNAL(clicked()), SLOT(accept()) );        
	cancel = new QPushButton( "Cancel", this );
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

	
	frequency=new SpinBox(this,"Frequency");
	frequency->setValue(modifier->getFrequency() );

	phase=new SpinBox(this,"Phase      ");
	phase->setValue(modifier->getPhase() );

	setGeometry(10,10,150,130);
	setMinimumSize(150,130);
	setMaximumSize(150,130);
}

void MapModifierDialog::reject()
{
	done(-1);
}

void MapModifierDialog::accept()
{
	
	modifier->setFrequency(frequency->getValue() );
	modifier->setPhase(phase->getValue() );

	done(0);
}


MapModifierDialog::~MapModifierDialog()
{
}

void MapModifierDialog::setGeometry(int x, int y, int w, int h)
{


	frequency->setGeometry(5,5,120,20);
	phase->setGeometry(5,30,120,20);

	ok->setGeometry( w-85,h-35, 70,30 );       
	cancel->setGeometry( w-85,h-65, 70,30 );

	QDialog::setGeometry(x,y,w,h);
}

		
