/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** spinbox.h
*/
#ifndef __SPINBOX_H__
#define __SPINBOX_H__

#include <qwidget.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qvalidator.h>
#include <stdio.h>
#include <stdlib.h>
#include <qlabel.h>

class	 SpinBox: public QWidget
{
Q_OBJECT

protected:
	double			 value,step,topV,downV;
	QPushButton		*up,*down;
	QLineEdit		*edit;
	QDoubleValidator	*qdv;
	QLabel			*label;
	char 			*buffer;

public:
	SpinBox(QWidget *parent,char *name="",double value=0.0);
	~SpinBox();
	void setGeometry(int,int,int,int);
	void setLabel(char *);
	void DownTopValue(double,double);
public slots:	
	double getValue();
	void setValue(double);
	void setEnabled(bool);
protected slots:
	void upClicked();
	void downClicked();
	void released();
	void newText(const char *);

 signals:
	void changed();


};


#endif

